###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for openldap FEDORA-2007-741
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861482);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-741");
  script_cve_id("");
  script_name(english: "Fedora Update for openldap FEDORA-2007-741");
  desc["english"] = "

  Vulnerability Insight:
  OpenLDAP is an open source suite of LDAP (Lightweight Directory Access
  Protocol) applications and development tools. LDAP is a set of
  protocols for accessing directory services (usually phone book style
  information, but other information is possible) over the Internet,
  similar to the way DNS (Domain Name System) information is propagated
  over the Internet. The openldap package contains configuration files,
  libraries, and documentation for OpenLDAP


  Affected Software/OS:
  openldap on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-November/msg00460.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of openldap");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"openldap", rpm:"openldap~2.3.30~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/openldap-servers-sql", rpm:"x86_64/openldap-servers-sql~2.3.30~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/openldap", rpm:"x86_64/openldap~2.3.30~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/compat-openldap", rpm:"x86_64/compat-openldap~2.3.30_2.2.29~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/openldap-debuginfo", rpm:"x86_64/debug/openldap-debuginfo~2.3.30~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/openldap-servers", rpm:"x86_64/openldap-servers~2.3.30~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/openldap-devel", rpm:"x86_64/openldap-devel~2.3.30~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/openldap-clients", rpm:"x86_64/openldap-clients~2.3.30~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/openldap-clients", rpm:"i386/openldap-clients~2.3.30~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/openldap-servers", rpm:"i386/openldap-servers~2.3.30~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/openldap-devel", rpm:"i386/openldap-devel~2.3.30~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/openldap", rpm:"i386/openldap~2.3.30~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/compat-openldap", rpm:"i386/compat-openldap~2.3.30_2.2.29~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/openldap-debuginfo", rpm:"i386/debug/openldap-debuginfo~2.3.30~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/openldap-servers-sql", rpm:"i386/openldap-servers-sql~2.3.30~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}