###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for libX11 FEDORA-2007-427
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861441);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-427");
  script_cve_id("");
  script_name(english: "Fedora Update for libX11 FEDORA-2007-427");
  desc["english"] = "

  Vulnerability Insight:
  X.Org X11 libX11 runtime library
  
  ---------------------------------------------------------------------
  
  * Fri Apr  6 2007 Adam Jackson &lt;ajax redhat com&gt; 1.0.0-4
  - libX11-cve-2007-1667.patch: Fix CVE 2007-1667
  * Tue Jun 20 2006 Mike A. Harris &lt;mharris redhat com&gt; 1.0.1-3.FC5.0
  - Added libX11-1.0.1-setuid.diff to fix potential security issue (#196094)
  - Change dependency on &quot;filesystem&quot; package to &quot;xorg-x11-filesystem&quot; package,
    so we can control this dep centrally.
  - Added NEWS to doc list


  Affected Software/OS:
  libX11 on Fedora Core 5

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-April/msg00030.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libX11");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC5")
{

  if(isrpmvuln(pkg:"libX11", rpm:"libX11~1.0.0~4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/libX11-debuginfo", rpm:"x86_64/debug/libX11-debuginfo~1.0.0~4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/libX11-devel", rpm:"x86_64/libX11-devel~1.0.0~4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/libX11", rpm:"x86_64/libX11~1.0.0~4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/libX11-debuginfo", rpm:"i386/debug/libX11-debuginfo~1.0.0~4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/libX11-devel", rpm:"i386/libX11-devel~1.0.0~4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/libX11", rpm:"i386/libX11~1.0.0~4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}