###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_chm2pdf_insec_tmp_file_crtn_vuln.nasl 569 2008-12-09 10:16:16Z dec $
#
# chm2pdf Insecure Temporary File Creation or DoS Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800316);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2008-5298", "CVE-2008-5299");
  script_bugtraq_id(31735);
  script_name(english:"chm2pdf Insecure Temporary File Creation or DoS Vulnerability");
  desc["english"] = "

  Overview: This host is installed with chm2pdf and is prone to Insecure
  Temporary File Creation or Denial of Service Vulnerability.

  Vulnerability Insight:
  The vulnerability is caused due to following,
  - error in .chm file in /tmp/chm2pdf/orig and /tmp/chm2pdf/work temporary
    directories.
  - uses temporary files in directories with fixed names.

  Impact:
  Successful exploitation will allow local users to delete arbitrary files
  via symlink attack or corrupt sensitive files, which may also result in a
  denial of service.

  Impact Level: Application

  Affected Software/OS:
  chm2pdf version prior to 0.9.1 on Debian

  Fix: Upgrade to higher version or Apply patches from,
  http://bugs.debian.org/cgi-bin/bugreport.cgi?msg=20;filename=chm2pdf_nmu.diff;att=1;bug=501959

  ******
  NOTE: Please ignore this warning if already patch is applied.
  ******

  References:
  http://secunia.com/advisories/32257/
  http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=501959
  http://www.openwall.com/lists/oss-security/2008/12/01/5

  CVSS Score:
    CVSS Base Score     : 6.9 (AV:L/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 5.1
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of chm2pdf");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Denial of Service");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

# Exit if other than Debian platform
if(ssh_cmd(socket:sock, cmd:"cat /etc/debian_version") !~ "^[0-9.]+"){
  exit(0);
}

binPaths = find_file(file_name:"chm2pdf", file_path:"/", useregex:TRUE,
                     regexpar:"$", sock:sock);
foreach c2pBin (binPaths)
{
  c2pVer = get_bin_version(full_prog_name:chomp(c2pBin), version_argv:"--version",
                           ver_pattern:"version ([0-9.]+)", sock:sock);
  if(c2pVer[1] != NULL)
  {
    if(version_is_less(version:c2pVer[1], test_version:"0.9.1")){
      security_hole(0);
    }
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
