###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apache_struts_xss_vuln.nasl 1629 2009-04-22 15:26:34Z apr $
#
# Apache Struts Cross Site Scripting Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800278);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6682");
  script_name(english:"Apache Struts Cross Site Scripting Vulnerability");
  desc["english"] = "

  Overview:
  This host is running Apache Struts and is prone to Cross Site Scripting
  Vulnerability.

  Vulnerability Insight:
  This flaw is caused due to improper sanitization of the user supplied input
  in '<s:url>' and '<s:a ...>' tag which doesn't encode the URL parameter when
  specified in the action attribute which causes XSS attacks.

  Impact:
  Successful exploitation will let the attacker issue malicious URL or can inject
  malicious codes inside the web page contents to gain sensitive information.

  Impact Level: Application

  Affected Software/OS:
  Apache Struts version 2.0 and prior to 2.0.11.1
  Apache Struts version 2.1 and prior to 2.1.1

  Fix: Upgrade to Apache Struts version 2.1.1 or 2.0.11.1.
  http://struts.apache.org/download.cgi

  References:
  https://issues.apache.org/struts/browse/WW-2414
  https://issues.apache.org/struts/browse/WW-2427

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for Struts Version");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Web application abuses");
  script_dependencies("gb_apache_struts_detect.nasl");
  script_require_ports("Services/www", 8080);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

strutsPort = get_http_port(default:8080);
if(!strutsPort){
  exit(0);
}

strutsVer = get_kb_item("www/" + strutsPort + "/Apache/Struts");
strutsVer = eregmatch(pattern:"^(.+) under (/.*)$", string:strutsVer);
if(!strutsVer[1]){
  exit(0);
}

if(version_in_range(version:strutsVer[1], test_version:"2.0", test_version2:"2.0.11") ||
   version_in_range(version:strutsVer[1], test_version:"2.1", test_version2:"2.1.0")){
  security_warning(strutsPort);
}
