###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for yum-rhn-plugin RHSA-2008:0815-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870098);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0815-01");
  script_cve_id("CVE-2008-3270");
  script_name(english: "RedHat Update for yum-rhn-plugin RHSA-2008:0815-01");
  desc["english"] = "

  Vulnerability Insight:
  The yum-rhn-plugin provides support for yum to securely access a Red Hat
  Network (RHN) server for software updates.
  
  It was discovered that yum-rhn-plugin did not verify the SSL certificate
  for all communication with a Red Hat Network server. An attacker able to
  redirect the network communication between a victim and an RHN server could
  use this flaw to provide malicious repository metadata. This metadata could
  be used to block the victim from receiving specific security updates.
  (CVE-2008-3270)
  
  This flaw did not allow an attacker to install malicious packages. Package
  signatures were verified and only packages signed with a trusted Red Hat
  GPG key were installed.
  
  Red Hat would like to thank Justin Samuel for discussing various package
  update mechanism flaws which led to our discovery of this issue.
  
  Users of yum-rhn-plugin are advised to upgrade to this updated packages,
  which resolves this issue.


  Affected Software/OS:
  yum-rhn-plugin on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-August/msg00014.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of yum-rhn-plugin");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"yum-rhn-plugin", rpm:"yum-rhn-plugin~0.5.3~12.el5_2.9", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}