###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for kernel RHSA-2008:0055-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870100);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0055-01");
  script_cve_id("CVE-2007-4130", "CVE-2007-5500", "CVE-2007-6063", "CVE-2007-6151", "CVE-2007-6206", "CVE-2007-6694", "CVE-2008-0001");
  script_name(english: "RedHat Update for kernel RHSA-2008:0055-01");
  desc["english"] = "

  Vulnerability Insight:
  The kernel packages contain the Linux kernel, the core of any Linux
  operating system.
  
  These updated kernel packages fix the following security issues:
  
  A flaw was found in the virtual filesystem (VFS). A local unprivileged
  user could truncate directories to which they had write permission; this
  could render the contents of the directory inaccessible. (CVE-2008-0001,
  Important)
  
  A flaw was found in the implementation of ptrace. A local unprivileged user
  could trigger this flaw and possibly cause a denial of service (system
  hang). (CVE-2007-5500, Important)
  
  A flaw was found in the way the Red Hat Enterprise Linux 4 kernel handled
  page faults when a CPU used the NUMA method for accessing memory on Itanium
  architectures. A local unprivileged user could trigger this flaw and cause
  a denial of service (system panic). (CVE-2007-4130, Important)
  
  A possible NULL pointer dereference was found in the chrp_show_cpuinfo
  function when using the PowerPC architecture. This may have allowed a local
  unprivileged user to cause a denial of service (crash).
  (CVE-2007-6694, Moderate)
  
  A flaw was found in the way core dump files were created. If a local user
  can get a root-owned process to dump a core file into a directory, which
  the user has write access to, they could gain read access to that core
  file. This could potentially grant unauthorized access to sensitive
  information. (CVE-2007-6206, Moderate)
  
  Two buffer overflow flaws were found in the Linux kernel ISDN subsystem. A
  local unprivileged  user could use these flaws to cause a denial of
  service. (CVE-2007-6063, CVE-2007-6151, Moderate)
  
  As well, these updated packages fix the following bug:
  
  * when moving volumes that contain multiple segments, and a mirror segment
  is not the first in the mapping table, running the &quot;pvmove /dev/[device]
  /dev/[device]&quot; command caused a kernel panic. A &quot;kernel: Unable to handle
  kernel paging request at virtual address [address]&quot; error was logged by
  syslog.
  
  Red Hat Enterprise Linux 4 users are advised to upgrade to these updated
  packages, which contain backported patches to resolve these issues.


  Affected Software/OS:
  kernel on Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-January/msg00019.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.9~67.0.4.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.9~67.0.4.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.9~67.0.4.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-hugemem", rpm:"kernel-hugemem~2.6.9~67.0.4.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-hugemem-devel", rpm:"kernel-hugemem-devel~2.6.9~67.0.4.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.9~67.0.4.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp-devel", rpm:"kernel-smp-devel~2.6.9~67.0.4.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenU", rpm:"kernel-xenU~2.6.9~67.0.4.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenU-devel", rpm:"kernel-xenU-devel~2.6.9~67.0.4.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.9~67.0.4.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-largesmp", rpm:"kernel-largesmp~2.6.9~67.0.4.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-largesmp-devel", rpm:"kernel-largesmp-devel~2.6.9~67.0.4.EL", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}