###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for samba RHSA-2007:1114-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870186);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2007:1114-01");
  script_cve_id("CVE-2007-6015", "CVE-2007-4572");
  script_name(english: "RedHat Update for samba RHSA-2007:1114-01");
  desc["english"] = "

  Vulnerability Insight:
  Samba is a suite of programs used by machines to share files, printers, and
  other information.
  
  A stack buffer overflow flaw was found in the way Samba authenticates
  remote users. A remote unauthenticated user could trigger this flaw to
  cause the Samba server to crash, or execute arbitrary code with the
  permissions of the Samba server. (CVE-2007-6015)
  
  Red Hat would like to thank Alin Rad Pop of Secunia Research for
  responsibly disclosing this issue.
  
  This update also fixes a regression caused by the fix for CVE-2007-4572,
  which prevented some clients from being able to properly access shares.
  
  Users of Samba are advised to upgrade to these updated packages, which
  contain a backported patch to resolve these issues.


  Affected Software/OS:
  samba on Red Hat Enterprise Linux AS (Advanced Server) version 2.1,
  Red Hat Enterprise Linux ES version 2.1,
  Red Hat Enterprise Linux WS version 2.1,
  Red Hat Enterprise Linux AS version 3,
  Red Hat Enterprise Linux ES version 3,
  Red Hat Enterprise Linux WS version 3,
  Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4,
  Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2007-December/msg00005.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of samba");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_2.1")
{

  if(isrpmvuln(pkg:"samba", rpm:"samba~2.2.12~1.21as.8.2", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~2.2.12~1.21as.8.2", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-common", rpm:"samba-common~2.2.12~1.21as.8.2", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-swat", rpm:"samba-swat~2.2.12~1.21as.8.2", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.25b~1.el5_1.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.0.25b~1.el5_1.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-common", rpm:"samba-common~3.0.25b~1.el5_1.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-debuginfo", rpm:"samba-debuginfo~3.0.25b~1.el5_1.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-swat", rpm:"samba-swat~3.0.25b~1.el5_1.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.25b~1.el4_6.4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.0.25b~1.el4_6.4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-common", rpm:"samba-common~3.0.25b~1.el4_6.4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-debuginfo", rpm:"samba-debuginfo~3.0.25b~1.el4_6.4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-swat", rpm:"samba-swat~3.0.25b~1.el4_6.4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_3")
{

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.9~1.3E.14.3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.0.9~1.3E.14.3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-common", rpm:"samba-common~3.0.9~1.3E.14.3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-debuginfo", rpm:"samba-debuginfo~3.0.9~1.3E.14.3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-swat", rpm:"samba-swat~3.0.9~1.3E.14.3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}