###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for irb CESA-2008:0981 centos4 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880120);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0981");
  script_cve_id("CVE-2008-4310", "CVE-2008-3656");
  script_name(english: "CentOS Update for irb CESA-2008:0981 centos4 i386");
  desc["english"] = "

  Vulnerability Insight:
  Ruby is an extensible, interpreted, object-oriented, scripting language. It
  has features to process text files and to do system management tasks.
  
  Vincent Danen reported, that Red Hat Security Advisory RHSA-2008:0897
  did not properly address a denial of service flaw in the WEBrick (Ruby
  HTTP server toolkit), known as CVE-2008-3656. This flaw allowed a
  remote attacker to send a specially-crafted HTTP request to a WEBrick
  server that would cause the server to use excessive CPU time. This
  update properly addresses this flaw. (CVE-2008-4310)
  
  All Ruby users should upgrade to these updated packages, which contain a
  correct patch that resolves this issue.


  Affected Software/OS:
  irb on CentOS 4

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-December/015514.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of irb");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS4")
{

  if(isrpmvuln(pkg:"irb", rpm:"irb~1.8.1~7.el4_7.2", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby", rpm:"ruby~1.8.1~7.el4_7.2", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-devel", rpm:"ruby-devel~1.8.1~7.el4_7.2", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-docs", rpm:"ruby-docs~1.8.1~7.el4_7.2", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-libs", rpm:"ruby-libs~1.8.1~7.el4_7.2", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-mode", rpm:"ruby-mode~1.8.1~7.el4_7.2", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-tcltk", rpm:"ruby-tcltk~1.8.1~7.el4_7.2", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}