###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for vsftpd CESA-2008:0579 centos3 x86_64
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880025);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0579");
  script_cve_id("CVE-2008-2375");
  script_name(english: "CentOS Update for vsftpd CESA-2008:0579 centos3 x86_64");
  desc["english"] = "

  Vulnerability Insight:
  vsftpd (Very Secure File Transfer Protocol (FTP) daemon) is a secure FTP
  server for Linux and Unix-like systems.
  
  The version of vsftpd as shipped in Red Hat Enterprise Linux 3 when used in
  combination with Pluggable Authentication Modules (PAM) had a memory leak
  on an invalid authentication attempt. Since vsftpd prior to version 2.0.5
  allows any number of invalid attempts on the same connection this memory
  leak could lead to an eventual DoS. (CVE-2008-2375)
  
  This update mitigates this security issue by including a backported patch
  which terminates a session after a given number of failed log in attempts.
  The default number of attempts is 3 and this can be configured using the
  &quot;max_login_fails&quot; directive.
  
  All vsftpd users should upgrade to this updated package, which addresses
  this vulnerability.


  Affected Software/OS:
  vsftpd on CentOS 3

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-July/015166.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of vsftpd");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS3")
{

  if(isrpmvuln(pkg:"vsftpd", rpm:"vsftpd~1.2.1~3E.16", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}