###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for rh-postgresql CESA-2008:0039 centos3 x86_64
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880077);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0039");
  script_cve_id("CVE-2007-3278", "CVE-2007-6600", "CVE-2007-6601");
  script_name(english: "CentOS Update for rh-postgresql CESA-2008:0039 centos3 x86_64");
  desc["english"] = "

  Vulnerability Insight:
  PostgreSQL is an advanced Object-Relational database management system
  (DBMS). The postgresql packages include the client programs and libraries
  needed to access a PostgreSQL DBMS server.
  
  A privilege escalation flaw was discovered in PostgreSQL. An authenticated
  attacker could create an index function that would be executed with
  administrator privileges during database maintenance tasks, such as
  database vacuuming. (CVE-2007-6600)
  
  A privilege escalation flaw was discovered in PostgreSQL's Database Link
  library (dblink). An authenticated attacker could use dblink to possibly
  escalate privileges on systems with &quot;trust&quot; or &quot;ident&quot; authentication
  configured. Please note that dblink functionality is not enabled by
  default, and can only by enabled by a database administrator on systems
  with the postgresql-contrib package installed.
  (CVE-2007-3278, CVE-2007-6601)
  
  All postgresql users should upgrade to these updated packages, which
  include PostgreSQL 7.3.21 and resolve these issues.


  Affected Software/OS:
  rh-postgresql on CentOS 3

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-January/014572.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of rh-postgresql");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS3")
{

  if(isrpmvuln(pkg:"rh-postgresql", rpm:"rh-postgresql~7.3.21~1", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rh-postgresql-contrib", rpm:"rh-postgresql-contrib~7.3.21~1", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rh-postgresql-devel", rpm:"rh-postgresql-devel~7.3.21~1", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rh-postgresql-docs", rpm:"rh-postgresql-docs~7.3.21~1", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rh-postgresql-jdbc", rpm:"rh-postgresql-jdbc~7.3.21~1", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rh-postgresql-libs", rpm:"rh-postgresql-libs~7.3.21~1", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rh-postgresql-pl", rpm:"rh-postgresql-pl~7.3.21~1", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rh-postgresql-python", rpm:"rh-postgresql-python~7.3.21~1", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rh-postgresql-server", rpm:"rh-postgresql-server~7.3.21~1", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rh-postgresql-tcl", rpm:"rh-postgresql-tcl~7.3.21~1", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rh-postgresql-test", rpm:"rh-postgresql-test~7.3.21~1", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}