###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for postgresql CESA-2008:0038 centos4 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880285);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0038");
  script_cve_id("CVE-2007-3278", "CVE-2007-4769", "CVE-2007-4772", "CVE-2007-6067", "CVE-2007-6600", "CVE-2007-6601");
  script_name(english: "CentOS Update for postgresql CESA-2008:0038 centos4 i386");
  desc["english"] = "

  Vulnerability Insight:
  PostgreSQL is an advanced Object-Relational database management system
  (DBMS). The postgresql packages include the client programs and libraries
  needed to access a PostgreSQL DBMS server.
  
  Will Drewry discovered multiple flaws in PostgreSQL's regular expression
  engine. An authenticated attacker could use these flaws to cause a denial
  of service by causing the PostgreSQL server to crash, enter an infinite
  loop, or use extensive CPU and memory resources while processing queries
  containing specially crafted regular expressions. Applications that accept
  regular expressions from untrusted sources may expose this problem to
  unauthorized attackers. (CVE-2007-4769, CVE-2007-4772, CVE-2007-6067)
  
  A privilege escalation flaw was discovered in PostgreSQL. An authenticated
  attacker could create an index function that would be executed with
  administrator privileges during database maintenance tasks, such as
  database vacuuming. (CVE-2007-6600)
  
  A privilege escalation flaw was discovered in PostgreSQL's Database Link
  library (dblink). An authenticated attacker could use dblink to possibly
  escalate privileges on systems with &quot;trust&quot; or &quot;ident&quot; authentication
  configured. Please note that dblink functionality is not enabled by
  default, and can only by enabled by a database administrator on systems
  with the postgresql-contrib package installed. (CVE-2007-3278,
  CVE-2007-6601)
  
  All postgresql users should upgrade to these updated packages, which
  include PostgreSQL 7.4.19 and 8.1.11, and resolve these issues.


  Affected Software/OS:
  postgresql on CentOS 4

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-January/014604.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of postgresql");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS4")
{

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~7.4.19~1.el4_6.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~7.4.19~1.el4_6.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~7.4.19~1.el4_6.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~7.4.19~1.el4_6.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-jdbc", rpm:"postgresql-jdbc~7.4.19~1.el4_6.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-libs", rpm:"postgresql-libs~7.4.19~1.el4_6.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pl", rpm:"postgresql-pl~7.4.19~1.el4_6.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-python", rpm:"postgresql-python~7.4.19~1.el4_6.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~7.4.19~1.el4_6.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-tcl", rpm:"postgresql-tcl~7.4.19~1.el4_6.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-test", rpm:"postgresql-test~7.4.19~1.el4_6.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}