#
#VID 8dbf7894-a9a8-11d9-a788-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52144);
 script_bugtraq_id(13166);
 script_cve_id("CVE-2005-0718");
 script_version ("$");
 name["english"] = "FreeBSD Ports: squid";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: squid

CVE-2005-0718
Squid 2.5.STABLE7 and earlier allows remote attackers to cause a
denial of service (segmentation fault) by aborting the connection
during a (1) PUT or (2) POST request, which causes Squid to access
previosuly freed memory.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.squid-cache.org/Versions/v2/2.5/bugs/#squid-2.5.STABLE7-post
http://www.squid-cache.org/bugs/show_bug.cgi?id=1224
http://www.vuxml.org/freebsd/8dbf7894-a9a8-11d9-a788-0001020eed82.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: squid";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"squid");
if(!isnull(bver) && revcomp(a:bver, b:"2.5.7_12")<=0) {
    security_note(0, data:"Package squid version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
