# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 881-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55794);
 script_bugtraq_id(15647, 15071);
 script_cve_id("CVE-2005-2969");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 881-1 (openssl096)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to openssl096
announced via advisory DSA 881-1.

Yutaka Oiwa discovered a vulnerability in the Open Secure Socket Layer
(OpenSSL) library that can allow an attacker to perform active
protocol-version rollback attacks that could lead to the use of the
weaker SSL 2.0 protocol even though both ends support SSL 3.0 or TLS
1.0.

The following matrix explains which version in which distribution has
this problem corrected.

oldstable (woody)      stable (sarge)     unstable (sid)
openssl          0.9.6c-2.woody.8       0.9.7e-3sarge1      0.9.8-3
openssl 094      0.9.4-6.woody.4             n/a              n/a
openssl 095      0.9.5a-6.woody.6            n/a              n/a
openssl 096           n/a               0.9.6m-1sarge1        n/a
openssl 097           n/a                    n/a            0.9.7g-5

We recommend that you upgrade your libssl packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20881-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 881-1 (openssl096)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libssl0.9.6", ver:"0.9.6m-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
