# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 732-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53561);
 script_cve_id("CVE-2005-1520", "CVE-2005-1521", "CVE-2005-1522", "CVE-2005-1523");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 732-1 (mailutils)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to mailutils
announced via advisory DSA 732-1.

infamous41md discovered several vulnerabilities in the GNU mailutils
package which contains utilities for handling mail.  These problems
can lead to a denial of service or the execution of arbitrary code.
The Common Vulnerabilities and Exposures project identifies the
following vulnerabilities.

CVE-2005-1520

Buffer overflow mail header handling may allow a remote attacker
to execute commands with the privileges of the targeted user.

CVE-2005-1521

Combined integer and heap overflow in the fetch routine can lead
to the execution of arbitrary code.

CVE-2005-1522

Denial of service in the fetch routine.

CVE-2005-1523

Format string vulnerability can lead to the execution of arbitrary
code.

For the stable distribution (woody) these problems have been fixed in
version 20020409-1woody2.

For the testing distribution (sarge) these problems have been fixed in
version 0.6.1-4.

For the unstable distribution (sid) these problems have been fixed in
version 0.6.1-4.

We recommend that you upgrade your mailutils packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20732-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 732-1 (mailutils)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mailutils-doc", ver:"20020409-1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmailutils0", ver:"20020409-1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmailutils0-dev", ver:"20020409-1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mailutils", ver:"20020409-1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mailutils-imap4d", ver:"20020409-1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mailutils-pop3d", ver:"20020409-1woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
