# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 518-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53208);
 script_bugtraq_id(10358);
 script_cve_id("CVE-2004-0411");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 518-1 (kdelibs)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to kdelibs
announced via advisory DSA 518-1.

iDEFENSE identified a vulnerability in the Opera web browser that
could be used by remote attackers to create or truncate arbitrary
files on the victims machine.  The KDE team discovered that a similar
vulnerability exists in KDE.

A remote attacker could entice a user to open a carefully crafted
telnet URI which may either create or truncate a file in the victims
home directory.  In KDE 3.2 and later versions the user is first
explicitly asked to confirm the opening of the telnet URI.

For the stable distribution (woody) this problem has been fixed in
version 2.2.2-13.woody.10.

We recommend that you upgrade your KDE libraries.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20518-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 518-1 (kdelibs)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kdelibs3-doc", ver:"2.2.2-13.woody.10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs-dev", ver:"2.2.2-13.woody.10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs3", ver:"2.2.2-13.woody.10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs3-bin", ver:"2.2.2-13.woody.10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs3-cups", ver:"2.2.2-13.woody.10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libarts", ver:"2.2.2-13.woody.10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libarts-alsa", ver:"2.2.2-13.woody.10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libarts-dev", ver:"2.2.2-13.woody.10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkmid", ver:"2.2.2-13.woody.10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkmid-alsa", ver:"2.2.2-13.woody.10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkmid-dev", ver:"2.2.2-13.woody.10", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
