# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1619-1 (python-dns)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61371);
 script_cve_id("CVE-2008-1447");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1619-1 (python-dns)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to python-dns
announced via advisory DSA 1619-1.

Multiple weaknesses have been identified in PyDNS, a DNS client
implementation for the Python language.  Dan Kaminsky identified a
practical vector of DNS response spoofing and cache poisoning,
exploiting the limited entropy in a DNS transaction ID and lack of
UDP source port randomization in many DNS implementations.  Scott
Kitterman noted that python-dns is vulnerable to this predictability,
as it randomizes neither its transaction ID nor its source port.
Taken together, this lack of entropy leaves applications using
python-dns to perform DNS queries highly susceptible to response
forgery.

The Common Vulnerabilities and Exposures project identifies this
class of weakness as CVE-2008-1447.

For the stable distribution (etch), these problems have been fixed in
version 2.3.0-5.2+etch1.

We recommend that you upgrade your python-dns package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201619-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1619-1 (python-dns)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"python-dns", ver:"2.3.0-5.2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
