# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1596-1 (typo3)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61173);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1596-1 (typo3)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to typo3
announced via advisory DSA 1596-1.

Several remote vulnerabilities have been discovered in the
TYPO3 content management framework.

Because of a not sufficiently secure default value of the TYPO3
configuration variable fileDenyPattern, authenticated backend users
could upload files that allowed to execute arbitrary code as the
webserver user.

User input processed by fe_adminlib.inc is not being properly filtered
to prevent Cross Site Scripting (XSS) attacks, which is exposed when
specific plugins are in use.

For the stable distribution (etch), these problems have been fixed in
version 4.0.2+debian-5.

For the unstable distribution (sid), these problems have been fixed in
version 4.1.7-1.

We recommend that you upgrade your typo3 package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201596-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1596-1 (typo3)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"typo3", ver:"4.0.2+debian-5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"typo3-src-4.0", ver:"4.0.2+debian-5", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
