# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1591-1 (libvorbis)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61107);
 script_cve_id("CVE-2008-1419", "CVE-2008-1420", "CVE-2008-1423");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1591-1 (libvorbis)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to libvorbis
announced via advisory DSA 1591-1.

Several local (remote) vulnerabilities have been discovered in libvorbis,
a library for the Vorbis general-purpose compressed audio codec. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2008-1419

libvorbis does not properly handle a zero value which allows remote
attackers to cause a denial of service (crash or infinite loop) or
trigger an integer overflow.

CVE-2008-1420

Integer overflow in libvorbis allows remote attackers to execute
arbitrary code via a crafted OGG file, which triggers a heap overflow.

CVE-2008-1423

Integer overflow in libvorbis allows remote attackers to cause a denial
of service (crash) or execute arbitrary code via a crafted OGG file
which triggers a heap overflow.

For the stable distribution (etch), these problems have been fixed in version
1.1.2.dfsg-1.4.

For the unstable distribution (sid), these problems have been fixed in
version 1.2.0.dfsg-3.1.

We recommend that you upgrade your libvorbis package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201591-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1591-1 (libvorbis)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libvorbisenc2", ver:"1.1.2.dfsg-1.4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbis0a", ver:"1.1.2.dfsg-1.4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbisfile3", ver:"1.1.2.dfsg-1.4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbis-dev", ver:"1.1.2.dfsg-1.4", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
