# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1397-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58729);
 script_cve_id("CVE-2007-5197");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1397-1 (mono)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to mono
announced via advisory DSA 1397-1.

An integer overflow in the BigInteger data type implementation has been
discovred in the free .NET runtime Mono.

The oldstable distribution (sarge) doesn't contain mono.

For the stable distribution (etch) this problem has been fixed in
version 1.2.2.1-1etch1. A powerpc build will be provided later.

The unstable distribution (sid) will be fixed soon.

We recommend that you upgrade your mono packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201397-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1397-1 (mono)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libmono-accessibility1.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-accessibility2.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-bytefx0.7.6.1-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-bytefx0.7.6.2-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-c5-1.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-cairo1.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-cairo2.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-corlib1.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-corlib2.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-cscompmgd7.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-cscompmgd8.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-data-tds1.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-data-tds2.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-firebirdsql1.7-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-ldap1.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-ldap2.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-microsoft-build2.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-microsoft7.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-microsoft8.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-npgsql1.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-npgsql2.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-oracle1.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-oracle2.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-peapi1.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-peapi2.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-relaxng1.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-relaxng2.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-security1.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-security2.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-sharpzip0.6-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-sharpzip0.84-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-sharpzip2.6-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-sharpzip2.84-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-sqlite1.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-sqlite2.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-system-data1.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-system-data2.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-system-ldap1.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-system-ldap2.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-system-messaging1.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-system-messaging2.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-system-runtime1.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-system-runtime2.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-system-web1.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-system-web2.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-system1.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-system2.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-winforms1.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-winforms2.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono1.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono2.0-cil", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mono-gac", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mono-gmcs", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mono-mcs", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mono-mjs", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono-dev", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmono0", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mono", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mono-common", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mono-devel", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mono-jay", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mono-jit", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mono-runtime", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mono-utils", ver:"1.2.2.1-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
