# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1343-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58635);
 script_cve_id("CVE-2007-2799", "CVE-2007-2026");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1343-2 (file)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to file
announced via advisory DSA 1343-2.

The Debian 4.0r1 release contains a file package with the same version
number as the last security update (4.17-5etch2), potentially overriding
it.  This security advisory reissues DSA-1343-1 with a higher version
number, to ensure that its changes remain in effect.  The changes from
Debian 4.0r1 (which fix a minor denial of service issue, CVE-2007-2026)
are included as well.

For the stable distribution (etch), this problem has been fixed in
version 4.17-5etch3.

For the unstable distribution (sid), the security vulnerability has been
fixed in version 4.21-1.

The old stable distribution (sarge) is not affected by the security
vulnerability.

We recommend that you upgrade your file (4.17-5etch3) package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201343-2

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1343-2 (file)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libmagic-dev", ver:"4.17-5etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-magic", ver:"4.17-5etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"file", ver:"4.17-5etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagic1", ver:"4.17-5etch3", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
