# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1213-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57586);
 script_cve_id("CVE-2006-0082", "CVE-2006-4144", "CVE-2006-5456", "CVE-2006-5868");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1213-1 (imagemagick)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to imagemagick
announced via advisory DSA 1213-1.

Several remote vulnerabilities have been discovered in Imagemagick,
a collection of image manipulation programs, which may lead to the
execution of arbitrary code. The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2006-0082

Daniel Kobras discovered that Imagemagick is vulnerable to format
string attacks in the filename parsing code.

CVE-2006-4144

Damian Put discovered that Imagemagick is vulnerable to buffer
overflows in the module for SGI images.

CVE-2006-5456

M Joonas Pihlaja discovered that Imagemagick is vulnerable to buffer
overflows in the module for DCM and PALM images.

CVE-2006-5868

Daniel Kobras discovered that Imagemagick is vulnerable to buffer
overflows in the module for SGI images.

This update also adresses regressions in the XCF codec, which were
introduced in the previous security update.

For the stable distribution (sarge) these problems have been fixed in
version 6:6.0.6.2-2.8.

For the upcoming stable distribution (etch) these problems have been
fixed in version 7:6.2.4.5.dfsg1-0.11.

For the unstable distribution (sid) these problems have been fixed in
version 7:6.2.4.5.dfsg1-0.11.

We recommend that you upgrade your imagemagick packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201213-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1213-1 (imagemagick)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"imagemagick", ver:"6.0.6.2-2.8", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++6", ver:"6.0.6.2-2.8", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++6-dev", ver:"6.0.6.2-2.8", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick6", ver:"6.0.6.2-2.8", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick6-dev", ver:"6.0.6.2-2.8", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perlmagick", ver:"6.0.6.2-2.8", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
