# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1169-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57337);
 script_cve_id("CVE-2006-4226", "CVE-2006-4380");
 script_bugtraq_id(19559);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1169-1 (mysql-dfsg-4.1)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to mysql-dfsg-4.1
announced via advisory DSA 1169-1.

Several local vulnerabilities have been discovered in the MySQL
database server.  The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2006-4226

Michal Prokopiuk discovered that remote authenticated users are
permitted to create and access a database if the lowercase
spelling is the same as one they have been granted access to.

CVE-2006-4380

Beat Vontobel discovered that certain queries replicated to a
slave could crash the client and thus terminate the replication.

For the stable distribution (sarge) these problems have been fixed in
version 4.1.11a-4sarge7.  Version 4.0 is not affected by these
problems.

For the unstable distribution (sid) these problems have been fixed in
version 5.0.24-3.  The replication problem only exists in version 4.1.

We recommend that you upgrade your mysql-server-4.1 package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201169-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1169-1 (mysql-dfsg-4.1)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mysql-common-4.1", ver:"4.1.11a-4sarge7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient14", ver:"4.1.11a-4sarge7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient14-dev", ver:"4.1.11a-4sarge7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-client-4.1", ver:"4.1.11a-4sarge7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server-4.1", ver:"4.1.11a-4sarge7", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
