# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1159-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57302);
 script_cve_id("CVE-2006-2779", "CVE-2006-3805", "CVE-2006-3806", "CVE-2006-3807", "CVE-2006-3808", "CVE-2006-3809", "CVE-2006-3810");
 script_bugtraq_id(18228,19181);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1159-1 (mozilla-thunderbird)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to mozilla-thunderbird
announced via advisory DSA 1159-1.

Several security related problems have been discovered in Mozilla and
derived products such as Mozilla Thunderbird.  The Common
Vulnerabilities and Exposures project identifies the following
vulnerabilities:

CVE-2006-2779

Mozilla team members discovered several crashes during testing of
the browser engine showing evidence of memory corruption which may
also lead to the execution of arbitrary code.  The last bit of
this problem will be corrected with the next update.  You can
prevent any trouble by disabling Javascript.  [MFSA-2006-32]

CVE-2006-3805

The Javascript engine might allow remote attackers to execute
arbitrary code.  [MFSA-2006-50]

CVE-2006-3806

Multiple integer overflows in the Javascript engine might allow
remote attackers to execute arbitrary code.  [MFSA-2006-50]

CVE-2006-3807

Specially crafted Javascript allows remote attackers to execute
arbitrary code.  [MFSA-2006-51]

CVE-2006-3808

Remote AutoConfig (PAC) servers could execute code with elevated
privileges via a specially crafted PAC script.  [MFSA-2006-52]

CVE-2006-3809

Scripts with the UniversalBrowserRead privilege could gain
UniversalXPConnect privileges and possibly execute code or obtain
sensitive data.  [MFSA-2006-53]

CVE-2006-3810

A cross-site scripting vulnerability allows remote attackers to
inject arbitrary web script or HTML.  [MFSA-2006-54]

For the stable distribution (sarge) these problems have been fixed in
version 1.0.2-2.sarge1.0.8b.1.

For the unstable distribution (sid) these problems have been fixed in
version 1.5.0.5-1.

We recommend that you upgrade your mozilla-thunderbird package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201159-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1159-1 (mozilla-thunderbird)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"1.0.2-2.sarge1.0.8b.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"1.0.2-2.sarge1.0.8b.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird-inspector", ver:"1.0.2-2.sarge1.0.8b.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird-offline", ver:"1.0.2-2.sarge1.0.8b.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird-typeaheadfind", ver:"1.0.2-2.sarge1.0.8b.1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
