# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0445 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63869);
 script_cve_id("CVE-2008-2086", "CVE-2008-5339", "CVE-2008-5340", "CVE-2008-5342", "CVE-2008-5343", "CVE-2008-5344", "CVE-2008-5345", "CVE-2008-5346", "CVE-2008-5348", "CVE-2008-5350", "CVE-2008-5351", "CVE-2008-5353", "CVE-2008-5354", "CVE-2008-5359", "CVE-2008-5360");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0445";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0445.

The IBM 1.4.2 SR13 Java release includes the IBM Java 2 Runtime
Environment and the IBM Java 2 Software Development Kit.

This update fixes several vulnerabilities in the IBM Java 2 Runtime
Environment and the IBM Java 2 Software Development Kit. These
vulnerabilities are summarized on the IBM Security alerts page listed in
the References section. (CVE-2008-2086, CVE-2008-5339, CVE-2008-5340,
CVE-2008-5342, CVE-2008-5343, CVE-2008-5344, CVE-2008-5345, CVE-2008-5346,
CVE-2008-5348, CVE-2008-5350, CVE-2008-5351, CVE-2008-5353, CVE-2008-5354,
CVE-2008-5359, CVE-2008-5360)

All users of java-1.4.2-ibm are advised to upgrade to these updated
packages, which contain the IBM 1.4.2 SR13 Java release. All running
instances of IBM Java must be restarted for the update to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0445.html
http://www.redhat.com/security/updates/classification/#critical
http://www.ibm.com/developerworks/java/jdk/alerts/

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0445";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"java-1.4.2-ibm", rpm:"java-1.4.2-ibm~1.4.2.13~1jpp.1.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.4.2-ibm-demo", rpm:"java-1.4.2-ibm-demo~1.4.2.13~1jpp.1.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.4.2-ibm-devel", rpm:"java-1.4.2-ibm-devel~1.4.2.13~1jpp.1.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.4.2-ibm-jdbc", rpm:"java-1.4.2-ibm-jdbc~1.4.2.13~1jpp.1.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.4.2-ibm-plugin", rpm:"java-1.4.2-ibm-plugin~1.4.2.13~1jpp.1.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.4.2-ibm-src", rpm:"java-1.4.2-ibm-src~1.4.2.13~1jpp.1.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.4.2-ibm", rpm:"java-1.4.2-ibm~1.4.2.13~1jpp.1.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.4.2-ibm-demo", rpm:"java-1.4.2-ibm-demo~1.4.2.13~1jpp.1.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.4.2-ibm-devel", rpm:"java-1.4.2-ibm-devel~1.4.2.13~1jpp.1.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.4.2-ibm-javacomm", rpm:"java-1.4.2-ibm-javacomm~1.4.2.13~1jpp.1.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.4.2-ibm-jdbc", rpm:"java-1.4.2-ibm-jdbc~1.4.2.13~1jpp.1.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.4.2-ibm-plugin", rpm:"java-1.4.2-ibm-plugin~1.4.2.13~1jpp.1.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.4.2-ibm-src", rpm:"java-1.4.2-ibm-src~1.4.2.13~1jpp.1.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.4.2-ibm", rpm:"java-1.4.2-ibm~1.4.2.13~1jpp.1.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.4.2-ibm-demo", rpm:"java-1.4.2-ibm-demo~1.4.2.13~1jpp.1.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.4.2-ibm-devel", rpm:"java-1.4.2-ibm-devel~1.4.2.13~1jpp.1.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.4.2-ibm-javacomm", rpm:"java-1.4.2-ibm-javacomm~1.4.2.13~1jpp.1.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.4.2-ibm-jdbc", rpm:"java-1.4.2-ibm-jdbc~1.4.2.13~1jpp.1.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.4.2-ibm-plugin", rpm:"java-1.4.2-ibm-plugin~1.4.2.13~1jpp.1.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.4.2-ibm-src", rpm:"java-1.4.2-ibm-src~1.4.2.13~1jpp.1.el5", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
