# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0313 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63474);
 script_cve_id("CVE-2008-4680", "CVE-2008-4681", "CVE-2008-4682", "CVE-2008-4683", "CVE-2008-4684", "CVE-2008-4685", "CVE-2008-5285", "CVE-2009-0599", "CVE-2009-0600");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0313";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0313.

Wireshark is a program for monitoring network traffic. Wireshark was
previously known as Ethereal.

Multiple buffer overflow flaws were found in Wireshark. If Wireshark read
a malformed packet off a network or opened a malformed dump file, it could
crash or, possibly, execute arbitrary code as the user running Wireshark.
(CVE-2008-4683, CVE-2009-0599)

Several denial of service flaws were found in Wireshark. Wireshark could
crash or stop responding if it read a malformed packet off a network, or
opened a malformed dump file. (CVE-2008-4680, CVE-2008-4681, CVE-2008-4682,
CVE-2008-4684, CVE-2008-4685, CVE-2008-5285, CVE-2009-0600)

Users of wireshark should upgrade to these updated packages, which contain
Wireshark version 1.0.6, and resolve these issues. All running instances of
Wireshark must be restarted for the update to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0313.html
http://www.redhat.com/security/updates/classification/#important

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0313";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"wireshark", rpm:"wireshark~1.0.6~EL3.3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-debuginfo", rpm:"wireshark-debuginfo~1.0.6~EL3.3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-gnome", rpm:"wireshark-gnome~1.0.6~EL3.3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark", rpm:"wireshark~1.0.6~2.el4_7", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-debuginfo", rpm:"wireshark-debuginfo~1.0.6~2.el4_7", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-gnome", rpm:"wireshark-gnome~1.0.6~2.el4_7", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark", rpm:"wireshark~1.0.6~2.el5_3", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-debuginfo", rpm:"wireshark-debuginfo~1.0.6~2.el5_3", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-gnome", rpm:"wireshark-gnome~1.0.6~2.el5_3", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
