/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.lt;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_lt extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Falkland = new String[] {
               "Folkland\u0173 sal\u0173 \u017eiemos laikas",
               "FIST",
               "Folkland\u0173 sal\u0173 vasaros laikas",
               "FIST",
               "Folkland\u0173 sal\u0173 laikas",
               "FIT",
            };
        final String[] Iran = new String[] {
               "Irano \u017eiemos laikas",
               "IST",
               "Irano vasaros laikas",
               "IDT",
               "Irano laikas",
               "IT",
            };
        final String[] Cape_Verde = new String[] {
               "Verde i\u0161ky\u0161ulio \u017eiemos laikas",
               "CVST",
               "Verde i\u0161ky\u0161ulio vasaros laikas",
               "CVST",
               "Verde i\u0161ky\u0161ulio laikas",
               "CVT",
            };
        final String[] Ponape = new String[] {
               "Ponap\u0117s laikas",
               "PT",
               "Ponape Summer Time",
               "PST",
               "Ponape Time",
               "PT",
            };
        final String[] Omsk = new String[] {
               "Omsko \u017eiemos laikas",
               "OST",
               "Omsko vasaros laikas",
               "OST",
               "Omsko laikas",
               "OT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae laikas",
               "KT",
               "Kosrae Summer Time",
               "KST",
               "Kosrae Time",
               "KT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havaj\u0173\u2013Aleut\u0173 \u017eiemos laikas",
               "HAST",
               "Havaj\u0173\u2013Aleut\u0173 vasaros laikas",
               "HADT",
               "Havaj\u0173\u2013Aleut\u0173 laikas",
               "HAT",
            };
        final String[] Myanmar = new String[] {
               "Myanmar laikas",
               "MT",
               "Myanmar Summer Time",
               "MST",
               "Myanmar Time",
               "MT",
            };
        final String[] Sakhalin = new String[] {
               "Sachalino \u017eiemos laikas",
               "SST",
               "Sachalino vasaros laikas",
               "SST",
               "Sachalino laikas",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsko \u017eiemos laikas",
               "YST",
               "Jakutsko vasaros laikas",
               "YST",
               "Jakutsko laikas",
               "YT",
            };
        final String[] Gambier = new String[] {
               "Gambier laikas",
               "GT",
               "Gambier Summer Time",
               "GST",
               "Gambier Time",
               "GT",
            };
        final String[] Paraguay = new String[] {
               "Paragvajaus \u017eiemos laikas",
               "PST",
               "Paragvajaus vasaros laikas",
               "PST",
               "Paragvajaus laikas",
               "PT",
            };
        final String[] Nepal = new String[] {
               "Nepalo laikas",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] Maldives = new String[] {
               "Maldyv\u0173 laikas",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistano \u017eiemos laikas",
               "TST",
               "Turkmenistano vasaros laikas",
               "TST",
               "Turkmenistano laikas",
               "TT",
            };
        final String[] Truk = new String[] {
               "Truk laikas",
               "CT",
               "Chuuk Summer Time",
               "CST",
               "Chuuk Time",
               "CT",
            };
        final String[] Japan = new String[] {
               "Japonijos \u017eiemos laikas",
               "JST",
               "Japonijos vasaros laikas",
               "JDT",
               "Japonijos laikas",
               "JT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostoko \u017eiemos laikas",
               "VST",
               "Vladivostoko vasaros laikas",
               "VST",
               "Vladivostoko laikas",
               "VT",
            };
        final String[] Europe_Western = new String[] {
               "Vakar\u0173 Europos \u017eiemos laikas",
               "WEST",
               "Vakar\u0173 Europos vasaros laikas",
               "WEST",
               "Vakar\u0173 Europos laikas",
               "WET",
            };
        final String[] Bangladesh = new String[] {
               "Banglade\u0161o \u017eiemos laikas",
               "BST",
               "Banglade\u0161o vasaros laikas",
               "BST",
               "Banglade\u0161o laikas",
               "BT",
            };
        final String[] East_Timor = new String[] {
               "Ryt\u0173 Timoro laikas",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Greenland_Western = new String[] {
               "Grenlandijos vakar\u0173 \u017eiemos laikas",
               "WGST",
               "Grenlandijos vakar\u0173 vasaros laikas",
               "WGST",
               "Grenlandijos vakar\u0173 laikas",
               "WGT",
            };
        final String[] Marquesas = new String[] {
               "Marquesas laikas",
               "MT",
               "Marquesas Summer Time",
               "MST",
               "Marquesas Time",
               "MT",
            };
        final String[] Colombia = new String[] {
               "Kolumbijos \u017eiemos laikas",
               "CST",
               "Kolumbijos vasaros laikas",
               "CST",
               "Kolumbijos laikas",
               "CT",
            };
        final String[] Wake = new String[] {
               "Veiko salos Laikas",
               "WIT",
               "Wake Island Summer Time",
               "WIST",
               "Wake Island Time",
               "WIT",
            };
        final String[] Gulf = new String[] {
               "Gulf laikas",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Singapore = new String[] {
               "Singap\u016bro \u017eiemos laikas",
               "SST",
               "Singapore Daylight Time",
               "SDT",
               "Singapore Time",
               "ST",
            };
        final String[] Hovd = new String[] {
               "Hovd \u017eiemos laikas",
               "HST",
               "Hovd vasaros laikas",
               "HST",
               "Hovd laikas",
               "HT",
            };
        final String[] Amazon = new String[] {
               "Amazon\u0117s \u017eiemos laikas",
               "AST",
               "Amazon\u0117s vasaros laikas",
               "AST",
               "Amazon\u0117s laikas",
               "AT",
            };
        final String[] Tokelau = new String[] {
               "Tokelau laikas",
               "TT",
               "Tokelau Summer Time",
               "TST",
               "Tokelau Time",
               "TT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilberto sal\u0173 laikas",
               "GIT",
               "Gilbert Islands Summer Time",
               "GIST",
               "Gilbert Islands Time",
               "GIT",
            };
        final String[] Pakistan = new String[] {
               "Pakistano \u017eiemos laikas",
               "PST",
               "Pakistano vasaros laikas",
               "PST",
               "Pakistano laikas",
               "PT",
            };
        final String[] Mongolia = new String[] {
               "Ulan Batoro \u017eiemos laikas",
               "UBST",
               "Ulan Batoro vasaros laikas",
               "UBST",
               "Ulan Batoro laikas",
               "UBT",
            };
        final String[] Palau = new String[] {
               "Palau laikas",
               "PT",
               "Palau Summer Time",
               "PST",
               "Palau Time",
               "PT",
            };
        final String[] New_Caledonia = new String[] {
               "Naujosios Kaledonijos \u017eiemos laikas",
               "NCST",
               "Naujosios Kaledonijos vasaros laikas",
               "NCST",
               "Naujosios Kaledonijos laikas",
               "NCT",
            };
        final String[] Nauru = new String[] {
               "Nauru laikas",
               "NT",
               "Nauru Summer Time",
               "NST",
               "Nauru Time",
               "NT",
            };
        final String[] America_Pacific = new String[] {
               "Ramiojo vandenyno \u017eiemos laikas",
               "PST",
               "Ramiojo vandenyno vasaros laikas",
               "PDT",
               "Ramiojo vandenyno laikas",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "Vakar\u0173 Argentinos \u017eiemos laikas",
               "WAST",
               "Vakar\u0173 Argentinos vasaros laikas",
               "WAST",
               "Vakar\u0173 Argentinos laikas",
               "WAT",
            };
        final String[] Galapagos = new String[] {
               "Galapagos laikas",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] French_Guiana = new String[] {
               "Pranc\u016bz\u0173 Gajanos laikas",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Grenlandijos ryt\u0173 \u017eiemos laikas",
               "EGST",
               "Grenlandijos ryt\u0173 vasaros laikas",
               "EGST",
               "Grenlandijos ryt\u0173 laikas",
               "EGT",
            };
        final String[] Christmas = new String[] {
               "Kal\u0117d\u0173 salos laikas",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Volgograd = new String[] {
               "Volgogrado \u017eiemos laikas",
               "VST",
               "Volgogrado vasaros laikas",
               "VST",
               "Volgogrado laikas",
               "VT",
            };
        final String[] Korea = new String[] {
               "Kor\u0117jie\u010di\u0173 \u017eiemos laikas",
               "KST",
               "Kor\u0117jie\u010di\u0173 vasaros laikas",
               "KDT",
               "Kor\u0117jie\u010di\u0173 laikas",
               "KT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu \u017eiemos laikas",
               "VST",
               "Vanuatu vasaros laikas",
               "VST",
               "Vanuatu laikas",
               "VT",
            };
        final String[] Argentina = new String[] {
               "Argentinos \u017eiemos laikas",
               "AST",
               "Argentinos vasaros laikas",
               "AST",
               "Argentinos laikas",
               "AT",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe \u017eiemos laikas",
               "LHST",
               "Lord Howe vasaros laikas",
               "LHDT",
               "Lord Howe laikas",
               "LHT",
            };
        final String[] Kyrgystan = new String[] {
               "Kyrgystan laikas",
               "KT",
               "Kyrgystan Summer Time",
               "KST",
               "Kyrgystan Time",
               "KT",
            };
        final String[] Australia_Eastern = new String[] {
               "Centrin\u0117s ryt\u0173 Australijos \u017eiemos laikas",
               "AEST",
               "Ryt\u0173 Australijos vasaros laikas",
               "AEDT",
               "Ryt\u0173 Australijos laikas",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsko \u017eiemos laikas",
               "IST",
               "Irkutsko vasaros laikas",
               "IST",
               "Irkutsko laikas",
               "IT",
            };
        final String[] Mauritius = new String[] {
               "Mauricijaus \u017eiemos laikas",
               "MST",
               "Mauricijaus vasaros laikas",
               "MST",
               "Mauricijaus laikas",
               "MT",
            };
        final String[] Indian_Ocean = new String[] {
               "Indijos vandenyno laikas",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Choibalsan = new String[] {
               "Choibalsan \u017eiemos laikas",
               "CST",
               "Choibalsan vasaros laikas",
               "CST",
               "\u010coibalsano laikas",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Ryt\u0173 \u017eiemos laikas",
               "EST",
               "Ryt\u0173 vasaros laikas",
               "EDT",
               "Ryt\u0173 laikas",
               "ET",
            };
        final String[] Australia_Western = new String[] {
               "Vakar\u0173 Australijos \u017eiemos laikas",
               "AWST",
               "Vakar\u0173 Australijos vasaros laikas",
               "AWDT",
               "Vakar\u0173 Australijos laikas",
               "WAT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Centrin\u0117s vakar\u0173 Australijos \u017eiemos laikas",
               "ACWST",
               "Centrin\u0117s vakar\u0173 Australijos vasaros laikas",
               "ACWDT",
               "Centrin\u0117s vakar\u0173 Australijos laikas",
               "ACWT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsko \u017eiemos laikas",
               "KST",
               "Krasnojarsko vasaros laikas",
               "KST",
               "Krasnojarsko laikas",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ryt\u0173 Indonezijos laikas",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Venezuela = new String[] {
               "Venesuelos laikas",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairn laikas",
               "PT",
               "Pitcairn Summer Time",
               "PST",
               "Pitcairn Time",
               "PT",
            };
        final String[] Bhutan = new String[] {
               "Butano laikas",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronjos \u017eiemos laikas",
               "FNST",
               "Fernando de Noronjos vasaros laikas",
               "FNST",
               "Fernando de Noronjos laikas",
               "FNT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsko \u017eiemos laikas",
               "NST",
               "Novosibirsko vasaros laikas",
               "NST",
               "Novosibirsko laikas",
               "NT",
            };
        final String[] Malaysia = new String[] {
               "Malaizijos laikas",
               "MT",
               "Malaysia Summer Time",
               "MST",
               "Malaysia Time",
               "MT",
            };
        final String[] America_Mountain = new String[] {
               "Kaln\u0173 \u017eiemos laikas",
               "MST",
               "Kaln\u0173 vasaros laikas",
               "MDT",
               "Kaln\u0173 laikas",
               "MT",
            };
        final String[] Norfolk = new String[] {
               "Norfolko sal\u0173 laikas",
               "NIT",
               "Norfolk Islands Summer Time",
               "NIST",
               "Norfolk Islands Time",
               "NIT",
            };
        final String[] Niue = new String[] {
               "Niuj\u0117s laikas",
               "NT",
               "Niue Summer Time",
               "NST",
               "Niue Time",
               "NT",
            };
        final String[] Alaska = new String[] {
               "Aliaskos \u017eiemos laikas",
               "AKST",
               "Aliaskos vasaros laikas",
               "AKDT",
               "Aliaskos laikas",
               "AKT",
            };
        final String[] Armenia = new String[] {
               "Arm\u0117nijos \u017eiemos laikas",
               "AST",
               "Arm\u0117nijos vasaros laikas",
               "AST",
               "Arm\u0117nijos laikas",
               "AT",
            };
        final String[] Marshall_Islands = new String[] {
               "Mar\u0161alo sal\u0173 laikas",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Australia_Central = new String[] {
               "Centrin\u0117s Australijos \u017eiemos laikas",
               "ACST",
               "Centrin\u0117s Australijos vasaros laikas",
               "ACDT",
               "Centrin\u0117s Australijos laikas",
               "CAT",
            };
        final String[] Azores = new String[] {
               "Azor\u0173 sal\u0173 \u017eiemos laikas",
               "AST",
               "Azor\u0173 sal\u0173 vasaros laikas",
               "AST",
               "Azor\u0173 sal\u0173 laikas",
               "AT",
            };
        final String[] Reunion = new String[] {
               "Reunion laikas",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Indochina = new String[] {
               "Indokinijos laikas",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Ecuador = new String[] {
               "Ekvadoro laikas",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Magadan = new String[] {
               "Magadano \u017eiemos laikas",
               "MST",
               "Magadano vasaros laikas",
               "MST",
               "Magadano laikas",
               "MT",
            };
        final String[] Chatham = new String[] {
               "Chatham \u017eiemos laikas",
               "CST",
               "Chatham vasaros laikas",
               "CDT",
               "Chatham laikas",
               "CT",
            };
        final String[] Cuba = new String[] {
               "Kubos \u017eiemos laikas",
               "CST",
               "Kubos vasaros laikas",
               "CDT",
               "Kubos laikas",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Vakar\u0173 Afrikos \u017eiemos laikas",
               "WAST",
               "Vakar\u0173 Afrikos vasaros laikas",
               "WAST",
               "Vakar\u0173 Afrikos laikas",
               "WAT",
            };
        final String[] Moscow = new String[] {
               "Maskvos \u017eiemos laikas",
               "MST",
               "Maskvos vasaros laikas",
               "MST",
               "Maskvos laikas",
               "MT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Naujosios Gvin\u0117jos laikas",
               "PNGT",
               "Papua New Guinea Summer Time",
               "PNGST",
               "Papua New Guinea Time",
               "PNGT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Ryt\u0173 Kazachstano laikas",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] New_Zealand = new String[] {
               "Naujosios Zelandijos \u017eiemos laikas",
               "NZST",
               "Naujosios Zelandijos vasaros laikas",
               "NZDT",
               "Naujosios Zelandijos laikas",
               "NZT",
            };
        final String[] Hong_Kong = new String[] {
               "Honkongo \u017eiemos laikas",
               "HKST",
               "Honkongo vasaros laikas",
               "HKST",
               "Honkongo laikas",
               "HKT",
            };
        final String[] Brasilia = new String[] {
               "Brazilijos \u017eiemos laikas",
               "BST",
               "Brazilijos vasaros laikas",
               "BST",
               "Brazilijos laikas",
               "BT",
            };
        final String[] Taipei = new String[] {
               "Taip\u0117jaus \u017eiemos laikas",
               "TST",
               "Taip\u0117jaus vasaros laikas",
               "TDT",
               "Taip\u0117jaus laikas",
               "TT",
            };
        final String[] Cocos = new String[] {
               "Kokos\u0173 sal\u0173 laikas",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Afghanistan = new String[] {
               "Afganistano laikas",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Indonesia_Western = new String[] {
               "Vakar\u0173 Indonezijos laikas",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Brunei = new String[] {
               "Brun\u0117jaus Darussalam laikas",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Finikso sal\u0173 laikas",
               "PIT",
               "Phoenix Islands Summer Time",
               "PIST",
               "Phoenix Islands Time",
               "PIT",
            };
        final String[] Seychelles = new String[] {
               "Sei\u0161eli\u0173 sal\u0173 laikas",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Africa_Central = new String[] {
               "Centrin\u0117s Afrikos laikas",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Easter = new String[] {
               "Velyk\u0173 salos \u017eiemos laikas",
               "EIST",
               "Velyk\u0173 salos vasaros laikas",
               "EIST",
               "Velyk\u0173 salos laikas",
               "EIT",
            };
        final String[] South_Georgia = new String[] {
               "Piet\u0173 D\u017eord\u017eijos laikas",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] Indonesia_Central = new String[] {
               "Centrin\u0117s Indokinijos laikas",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Philippines = new String[] {
               "Filipin\u0173 \u017eiemos laikas",
               "PST",
               "Filipin\u0173 vasaros laikas",
               "PST",
               "Filipin\u0173 laikas",
               "PT",
            };
        final String[] Georgia = new String[] {
               "Gruzijos \u017eiemos laikas",
               "GST",
               "Gruzijos vasaros laikas",
               "GST",
               "Gruzijos laikas",
               "GT",
            };
        final String[] Bolivia = new String[] {
               "Bolivijos laikas",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Peru = new String[] {
               "Peru \u017eiemos laikas",
               "PST",
               "Peru vasaros laikas",
               "PST",
               "Peru laikas",
               "PT",
            };
        final String[] Chamorro = new String[] {
               "Chamorro laikas",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Newfoundland = new String[] {
               "Niufaundlendo \u017eiemos laikas",
               "NST",
               "Niufaundlendo vasaros laikas",
               "NDT",
               "Niufaundlendo laikas",
               "NT",
            };
        final String[] Line_Islands = new String[] {
               "Linijos sal\u0173 laikas",
               "LIT",
               "Line Islands Summer Time",
               "LIST",
               "Line Islands Time",
               "LIT",
            };
        final String[] Cook = new String[] {
               "Kuko sal\u0173 pus\u0117s \u017eiemos laikas",
               "CIST",
               "Kuko sal\u0173 pus\u0117s vasaros laikas",
               "CIHST",
               "Kuko sal\u0173 pus\u0117s laikas",
               "CIT",
            };
        final String[] America_Central = new String[] {
               "Centro \u017eiemos laikas",
               "CST",
               "Centro vasaros laikas",
               "CDT",
               "Centro laikas",
               "CT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ryt\u0173 Afrikos laikas",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaid\u017eano \u017eiemos laikas",
               "AST",
               "Azerbaid\u017eano vasaros laikas",
               "AST",
               "Azerbaid\u017eano laikas",
               "AT",
            };
        final String[] Guyana = new String[] {
               "Gajanos laikas",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgo \u017eiemos laikas",
               "YST",
               "Jekaterinburgo vasaros laikas",
               "YST",
               "Jekaterinburgo laikas",
               "YT",
            };
        final String[] China = new String[] {
               "Kinijos \u017eiemos laikas",
               "CST",
               "Kinijos vasaros laikas",
               "CDT",
               "Kinijos laikas",
               "CT",
            };
        final String[] Samoa = new String[] {
               "Samoa \u017eiemos laikas",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Tonga = new String[] {
               "Tongos \u017eiemos laikas",
               "TST",
               "Tongos vasaros laikas",
               "TST",
               "Tongos laikas",
               "TT",
            };
        final String[] Solomon = new String[] {
               "Saliamono sal\u0173 laikas",
               "SIT",
               "Solomon Islands Summer Time",
               "SIST",
               "Solomon Islands Time",
               "SIT",
            };
        final String[] Africa_Southern = new String[] {
               "Piet\u0173 Afrikos laikas",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Macquarie = new String[] {
               "Makvario laikas",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] French_Southern = new String[] {
               "Piet\u0173 Pranc\u016bzijos ir Antarktinis Laikas",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] Chile = new String[] {
               "\u010cil\u0117s \u017eiemos laikas",
               "CST",
               "\u010cil\u0117s vasaros laikas",
               "CST",
               "\u010cil\u0117s laikas",
               "CT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Vakar\u0173 Kazachstano laikas",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Israel = new String[] {
               "Izraelio \u017eiemos laikas",
               "IST",
               "Izraelio vasaros laikas",
               "IDT",
               "Izraelio laikas",
               "IT",
            };
        final String[] Tajikistan = new String[] {
               "Tad\u017eikijos laikas",
               "TT",
               "Tajikistan Summer Time",
               "TST",
               "Tajikistan Time",
               "TT",
            };
        final String[] Tahiti = new String[] {
               "Tai\u010dio laikas",
               "TT",
               "Tahiti Summer Time",
               "TST",
               "Tahiti Time",
               "TT",
            };
        final String[] Fiji = new String[] {
               "Fid\u017eio \u017eiemos laikas",
               "FST",
               "Fid\u017eio vasaros laikas",
               "FST",
               "Fid\u017eio laikas",
               "FT",
            };
        final String[] Europe_Central = new String[] {
               "Vidurio Europos \u017eiemos laikas",
               "CEST",
               "Vidurio Europos vasaros laikas",
               "CEST",
               "Vidurio Europos laikas",
               "CET",
            };
        final String[] Wallis = new String[] {
               "Wallis ir Futuna laikas",
               "WFT",
               "Wallis and Futuna Summer Time",
               "WFST",
               "Wallis and Futuna Time",
               "WFT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu laikas",
               "TT",
               "Tuvalu Summer Time",
               "TST",
               "Tuvalu Time",
               "TT",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistano \u017eiemos laikas",
               "UST",
               "Uzbekistano vasaros laikas",
               "UST",
               "Uzbekistano laikas",
               "UT",
            };
        final String[] Europe_Eastern = new String[] {
               "Ryt\u0173 Europos \u017eiemos laikas",
               "EEST",
               "Ryt\u0173 Europos vasaros laikas",
               "EEST",
               "Ryt\u0173 Europos laikas",
               "EET",
            };
        final String[] Atlantic = new String[] {
               "Atlanto \u017eiemos laikas",
               "AST",
               "Atlanto vasaros laikas",
               "ADT",
               "Atlanto laikas",
               "AT",
            };
        final String[] Uruguay = new String[] {
               "Urugvajaus \u017eiemos laikas",
               "UST",
               "Urugvajaus vasaros laikas",
               "UST",
               "Urugvajaus laikas",
               "UT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Douala", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "Asia/Yerevan", Armenia },
            { "Asia/Bangkok", Indochina },
            { "America/Bogota", Colombia },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Blantyre", Africa_Central },
            { "Europe/Volgograd", Volgograd },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Katmandu", Nepal },
            { "America/Resolute", America_Central },
            { "America/Anguilla", Atlantic },
            { "America/Regina", America_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Simferopol", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/North_Dakota/Center", America_Central },
            { "Indian/Kerguelen", French_Southern },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Bahia_Banderas", America_Central },
            { "Pacific/Rarotonga", Cook },
            { "Asia/Hebron", Europe_Eastern },
            { "Australia/Broken_Hill", Australia_Central },
            { "Antarctica/Casey", Australia_Western },
            { "PST8PDT", America_Pacific },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Guam", Chamorro },
            { "Africa/Maseru", Africa_Southern },
            { "America/Asuncion", Paraguay },
            { "America/Indiana/Winamac", America_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vientiane", Indochina },
            { "Africa/Niamey", Africa_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Asia/Brunei", Brunei },
            { "Africa/Djibouti", Africa_Eastern },
            { "Asia/Tbilisi", Georgia },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "Indian/Reunion", Reunion },
            { "Asia/Oral", Kazakhstan_Western },
            { "Africa/Lusaka", Africa_Central },
            { "America/Tortola", Atlantic },
            { "Asia/Kuching", Malaysia },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Europe/Vilnius", Europe_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "America/Moncton", Atlantic },
            { "America/Maceio", Brasilia },
            { "America/Belize", America_Central },
            { "America/Cuiaba", Amazon },
            { "Asia/Tashkent", Uzbekistan },
            { "Atlantic/Canary", Europe_Western },
            { "America/Rankin_Inlet", America_Central },
            { "Indian/Cocos", Cocos },
            { "America/Glace_Bay", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "America/Cambridge_Bay", America_Mountain },
            { "Indian/Mauritius", Mauritius },
            { "Australia/Brisbane", Australia_Eastern },
            { "America/Grenada", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Pacific/Auckland", New_Zealand },
            { "Africa/Nairobi", Africa_Eastern },
            { "Pacific/Norfolk", Norfolk },
            { "Asia/Irkutsk", Irkutsk },
            { "Pacific/Apia", Samoa },
            { "Pacific/Chatham", Chatham },
            { "America/Caracas", Venezuela },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Maputo", Africa_Central },
            { "America/Metlakatla", America_Pacific },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Pacific/Saipan", Chamorro },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Singapore", Singapore },
            { "Africa/Cairo", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "Pacific/Funafuti", Tuvalu },
            { "Asia/Taipei", Taipei },
            { "Pacific/Majuro", Marshall_Islands },
            { "Indian/Comoro", Africa_Eastern },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "Asia/Dili", East_Timor },
            { "America/Indiana/Marengo", America_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Indian/Chagos", Indian_Ocean },
            { "Europe/Luxembourg", Europe_Central },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Phnom_Penh", Indochina },
            { "Australia/Currie", Australia_Eastern },
            { "America/Cancun", America_Central },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Seoul", Korea },
            { "Antarctica/McMurdo", New_Zealand },
            { "Europe/Rome", Europe_Central },
            { "Atlantic/Stanley", Falkland },
            { "America/Lima", Peru },
            { "America/Dawson_Creek", America_Mountain },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Anadyr", Magadan },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Campo_Grande", Amazon },
            { "America/Hermosillo", America_Mountain },
            { "America/Boise", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/St_Kitts", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Tehran", Iran },
            { "America/Santa_Isabel", America_Pacific },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "Africa/Algiers", Europe_Central },
            { "America/Araguaina", Brasilia },
            { "America/St_Lucia", Atlantic },
            { "Pacific/Kiritimati", Line_Islands },
            { "Asia/Yakutsk", Yakutsk },
            { "Indian/Mahe", Seychelles },
            { "America/Panama", America_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Europe/Gibraltar", Europe_Central },
            { "America/Aruba", Atlantic },
            { "Asia/Muscat", Gulf },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "Australia/Lindeman", Australia_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "Pacific/Guadalcanal", Solomon },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Pago_Pago", Samoa },
            { "America/Edmonton", America_Mountain },
            { "America/Creston", America_Mountain },
            { "America/Noronha", Noronha },
            { "America/La_Paz", Bolivia },
            { "America/Dominica", Atlantic },
            { "Asia/Saigon", Indochina },
            { "Antarctica/Macquarie", Macquarie },
            { "MST7MDT", America_Mountain },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Luanda", Africa_Western },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Nauru", Nauru },
            { "Africa/Brazzaville", Africa_Western },
            { "America/Guadeloupe", Atlantic },
            { "Africa/Bangui", Africa_Western },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/Eirunepe", Amazon },
            { "Africa/Lubumbashi", Africa_Central },
            { "Antarctica/Palmer", Chile },
            { "Pacific/Galapagos", Galapagos },
            { "America/Monterrey", America_Central },
            { "Europe/Samara", Moscow },
            { "Europe/Monaco", Europe_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "Indian/Christmas", Christmas },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "America/Yakutat", Alaska },
            { "America/St_Vincent", Atlantic },
            { "Europe/Vienna", Europe_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Pacific/Niue", Niue },
            { "Africa/Gaborone", Africa_Central },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Lisbon", Europe_Western },
            { "America/Montevideo", Uruguay },
            { "Europe/Zurich", Europe_Central },
            { "America/Winnipeg", America_Central },
            { "America/Guyana", Guyana },
            { "America/Santarem", Brasilia },
            { "Asia/Macau", China },
            { "Asia/Vladivostok", Vladivostok },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Tahiti", Tahiti },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Thule", Atlantic },
            { "Europe/Copenhagen", Europe_Central },
            { "Asia/Thimphu", Bhutan },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Chihuahua", America_Mountain },
            { "America/Yellowknife", America_Mountain },
            { "Africa/Windhoek", Africa_Western },
            { "America/Cayman", America_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Omsk", Omsk },
            { "Europe/Chisinau", Europe_Eastern },
            { "Asia/Choibalsan", Choibalsan },
            { "Europe/Prague", Europe_Central },
            { "Africa/Harare", Africa_Central },
            { "America/Toronto", America_Eastern },
            { "America/Montserrat", Atlantic },
            { "Asia/Pyongyang", Korea },
            { "America/Porto_Velho", Amazon },
            { "Pacific/Truk", Truk },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Mexico_City", America_Central },
            { "America/El_Salvador", America_Central },
            { "Asia/Kashgar", China },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Port_of_Spain", Atlantic },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "Asia/Karachi", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Managua", America_Central },
            { "EST5EDT", America_Eastern },
            { "Pacific/Wallis", Wallis },
            { "America/Nome", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Rio_Branco", Amazon },
            { "Europe/Podgorica", Europe_Central },
            { "America/Santiago", Chile },
            { "America/Vancouver", America_Pacific },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Pacific/Wake", Wake },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Guatemala", America_Central },
            { "Europe/Oslo", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Dubai", Gulf },
            { "Asia/Harbin", China },
            { "Africa/Johannesburg", Africa_Southern },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Ojinaga", America_Mountain },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Barbados", Atlantic },
            { "Asia/Urumqi", China },
            { "Asia/Gaza", Europe_Eastern },
            { "America/Louisville", America_Eastern },
            { "Atlantic/Azores", Azores },
            { "America/Lower_Princes", Atlantic },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Blanc-Sablon", Atlantic },
            { "Africa/Juba", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Kiev", Europe_Eastern },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Jamaica", America_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Pitcairn", Pitcairn },
            { "Europe/Malta", Europe_Central },
            { "Europe/Madrid", Europe_Central },
            { "Asia/Magadan", Magadan },
            { "Asia/Kabul", Afghanistan },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Mbabane", Africa_Southern },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "Asia/Rangoon", Myanmar },
            { "America/Jujuy", Argentina },
            { "America/Buenos_Aires", Argentina },
            { "Europe/Athens", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Havana", Cuba },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Europe/San_Marino", Europe_Central },
            { "Pacific/Gambier", Gambier },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "Pacific/Easter", Easter },
            { "America/Menominee", America_Central },
            { "America/Juneau", Alaska },
            { "Pacific/Fakaofo", Tokelau },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Godthab", Greenland_Western },
            { "Africa/Libreville", Africa_Western },
            { "Pacific/Kosrae", Kosrae },
            { "America/St_Thomas", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "America/Shiprock", America_Mountain },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Pacific/Tongatapu", Tonga },
            { "Europe/Riga", Europe_Eastern },
            { "America/Guayaquil", Ecuador },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Manila", Philippines },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Kigali", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "Europe/Tirane", Europe_Central },
            { "America/Nipigon", America_Eastern },
            { "Asia/Chongqing", China },
            { "America/Cayenne", French_Guiana },
            { "Asia/Samarkand", Uzbekistan },
            { "Pacific/Fiji", Fiji },
            { "Australia/Darwin", Australia_Central },
            { "Europe/Skopje", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Midway", Samoa },
            { "Pacific/Palau", Palau },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Atlantic/Madeira", Europe_Western },
        };
        return data;
    }
}
