"use strict"
var os = require("os")

var hasUnicode = module.exports = function () {
  // Supported Win32 platforms (>XP) support unicode in the console, though
  // font support isn't fantastic.
  if (os.type() == "Windows_NT") { return true }

  var isUTF8 = /[.]UTF-8/
  if (isUTF8.test(process.env.LC_ALL)
   || process.env.LC_CTYPE == 'UTF-8'
   || isUTF8.test(process.env.LANG)) {
    return true
  }

  return false
}
