/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.testsuite;

import bossa.modules.Compilation;
import bossa.modules.fun;
import bossa.parser.JavaccParser;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nice.lang.dispatch;
import nice.tools.compiler.console.ConsoleOutput;
import nice.tools.testsuite.CompilerBugException;
import nice.tools.testsuite.NiceSourceFile;
import nice.tools.testsuite.TestNice;
import nice.tools.testsuite.TestSuite;
import nice.tools.testsuite.TestSuiteException;

public abstract class TestCase {
    private static final String ERROR_MSG = "Compilation failed with errors.";
    private static final String BUG_MSG = "Compilation failed because of a bug in the compiler.";
    private static final String WARNING_MSG = "Compilation successful despite warnings.";
    private static final String OK_MSG = "Compilation successful.";
    private TestSuite _testSuite;
    private List _niceSourceFiles = new ArrayList();
    private NiceSourceFile _currentSourceFile;
    private Set _dontCompilePackages = new HashSet();
    private ByteArrayOutputStream _compilerMessagesStream;
    private List _failPositions = new ArrayList();
    private int _lineCounter = 0;
    boolean isKnownBug;
    boolean skip;
    boolean noLocation;

    public TestCase(TestSuite suite) {
        this._testSuite = suite;
        this.createNewSourceFile();
    }

    private void createNewSourceFile() {
        this._currentSourceFile = new NiceSourceFile();
        this._niceSourceFiles.add(this._currentSourceFile);
        if (this._testSuite.hasGlobalSource()) {
            this._currentSourceFile.addImportGlobal();
        }
        this._lineCounter = 1;
    }

    protected List getFailPositions() {
        return this._failPositions;
    }

    public void consumeLine(String line) throws TestSuiteException {
        if (this.consumeKeywordLine(line)) {
            return;
        }
        ++this._lineCounter;
        this.consumeCommentedKeyword(line);
        this._currentSourceFile.consumeLine(line);
    }

    private boolean consumeKeywordLine(String line) throws TestSuiteException {
        if (!(line = line.trim()).startsWith("///")) {
            return false;
        }
        String keywordStatement = line.substring("///".length()).trim();
        if ("toplevel".equalsIgnoreCase(keywordStatement.toLowerCase())) {
            this._currentSourceFile.setStatus(1);
        } else if (keywordStatement.startsWith("package")) {
            if (!this._currentSourceFile.isEmpty()) {
                this.createNewSourceFile();
            }
            this._currentSourceFile.consumePackageKeyword(keywordStatement);
            if (keywordStatement.indexOf("dontcompile") != -1) {
                this._dontCompilePackages.add(this._currentSourceFile.getPackage());
            }
        } else {
            this._testSuite.consumeComment(line);
        }
        return true;
    }

    private void consumeCommentedKeyword(String line) {
        int startCommentPos;
        int pos = 0;
        while ((startCommentPos = line.indexOf("/*", pos)) != -1) {
            int endCommentPos;
            pos = endCommentPos = line.indexOf("*/", startCommentPos + 2);
            if (startCommentPos == -1 || endCommentPos == -1) {
                return;
            }
            String comment = line.substring(startCommentPos, endCommentPos);
            int keywordSignPos = line.indexOf("///");
            if (keywordSignPos < startCommentPos || endCommentPos < keywordSignPos) {
                return;
            }
            String keywordStatement = line.substring(keywordSignPos + "///".length(), endCommentPos).trim();
            if (!"fail here".equalsIgnoreCase(keywordStatement.toLowerCase())) continue;
            int columnNum = endCommentPos + 2;
            while (Character.isWhitespace(line.charAt(columnNum))) {
                ++columnNum;
            }
            int lineNum = this._lineCounter + this._currentSourceFile.getCountImports() + 2;
            this._failPositions.add(new FailPosition(this._currentSourceFile.getFileName(), lineNum, columnNum + 1, this._currentSourceFile, this._currentSourceFile.getStatus() == 0));
        }
    }

    public void writeFiles() throws TestSuiteException {
        for (NiceSourceFile sourceFile : this._niceSourceFiles) {
            sourceFile.write();
        }
        if (this._testSuite.hasGlobalSource()) {
            this._testSuite.getGlobalSource().write();
        }
    }

    public void performTest() {
        TestNice.getOutput().startTestCase(this);
    }

    private List getPackages() {
        ArrayList<String> packages = new ArrayList<String>();
        for (NiceSourceFile sourceFile : this._niceSourceFiles) {
            if (packages.contains(sourceFile.getPackage())) continue;
            packages.add(sourceFile.getPackage());
        }
        return packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compilePackages() throws TestSuiteException, CompilerBugException {
        this._compilerMessagesStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(this._compilerMessagesStream);
        PrintStream origOut = System.out;
        PrintStream origErr = System.err;
        System.setOut(out);
        System.setErr(out);
        boolean showMessages = false;
        try {
            List packageNames = this.getPackages();
            for (String packageName : packageNames) {
                if (this._dontCompilePackages.contains(packageName)) continue;
                int retval = this.compilePackage(packageName);
                switch (retval) {
                    case 2: {
                        showMessages = true;
                        throw new TestSuiteException(ERROR_MSG);
                    }
                    case 1: {
                        showMessages = true;
                        throw new CompilerBugException(BUG_MSG);
                    }
                    case 3: {
                        showMessages = true;
                    }
                }
            }
        }
        finally {
            System.setOut(origOut);
            System.setErr(origErr);
            try {
                this._compilerMessagesStream.close();
                out.close();
            }
            catch (IOException e) {}
        }
    }

    private int compilePackage(String packageName) throws TestSuiteException {
        String tempDir;
        ConsoleOutput output = nice.tools.compiler.console.fun.consoleOutput();
        Compilation compilation = fun.createCompilation(output, new JavaccParser());
        compilation.sourcePath = tempDir = TestNice.getTempFolder().getAbsolutePath();
        compilation.destinationDir = tempDir;
        compilation.runtimeFile = TestNice.getRuntime();
        if (TestNice.getGcc() == null) {
            nice.tools.compiler.fun.compile(compilation, packageName, null, null, false);
        } else {
            compilation.output = new File(tempDir, "testcase.jar").getPath();
            nice.tools.compiler.fun.compile(compilation, packageName, new File(tempDir, "testcase.exe").getPath(), TestNice.getGcc() + "/bin/gcj", false);
        }
        return output.statusCode;
    }

    public void runNative() throws TestSuiteException {
        try {
            String[] env = null;
            if (TestNice.getGcc() != null) {
                env = new String[]{"LD_LIBRARY_PATH=" + TestNice.getGcc() + "/lib"};
            }
            Process p = Runtime.getRuntime().exec(TestNice.getTempFolder() + "/testcase.exe", env);
            CharArrayWriter out = new CharArrayWriter();
            int exitValue = nice.tools.compiler.dispatch.waitFor(p, out);
            System.out.println(out.toString());
            if (exitValue != 0) {
                throw new TestSuiteException("Exit code: " + exitValue);
            }
        }
        catch (IOException e) {
            throw new TestSuiteException(e.getMessage());
        }
    }

    public void runJVM(String jvm, String main2) throws TestSuiteException {
        try {
            Process p = Runtime.getRuntime().exec(jvm + " -classpath " + TestNice.getTempFolder() + ":classes " + main2);
            CharArrayWriter out = new CharArrayWriter();
            int exitValue = nice.tools.compiler.dispatch.waitFor(p, out);
            System.out.println(out.toString());
            if (exitValue != 0) {
                throw new TestSuiteException("Exit code: " + exitValue);
            }
        }
        catch (IOException e) {
            throw new TestSuiteException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runMain() throws TestSuiteException {
        ByteArrayOutputStream mainMessagesStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(mainMessagesStream);
        PrintStream origOut = System.out;
        PrintStream origErr = System.err;
        System.setOut(out);
        System.setErr(out);
        try {
            if (TestNice.getGcc() != null) {
                this.runNative();
                return;
            }
            for (NiceSourceFile sourceFile : this._niceSourceFiles) {
                if (!sourceFile.hasMainMethod() || this._dontCompilePackages.contains(sourceFile.getPackage())) continue;
                if (TestNice.getJVM() != null) {
                    this.runJVM(TestNice.getJVM(), sourceFile.getPackage() + ".fun");
                    continue;
                }
                ClassLoader loader = TestNice.getClassLoader();
                try {
                    Class<?> c = Class.forName(sourceFile.getPackage() + ".fun", true, loader);
                    Class[] parameterTypes = new Class[]{String[].class};
                    Method m = c.getMethod("main", parameterTypes);
                    Object[] arguments = new Object[]{new String[0]};
                    try {
                        m.invoke(c.newInstance(), arguments);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getTargetException();
                    }
                }
                catch (Throwable e) {
                    dispatch.printStackTraceWithSourceInfo(e, out, loader);
                    throw new TestSuiteException("Exception while invoking main()", e);
                    return;
                }
            }
        }
        finally {
            System.setOut(origOut);
            System.setErr(origErr);
            try {
                mainMessagesStream.close();
                out.close();
            }
            catch (IOException e) {}
            if (mainMessagesStream.size() != 0) {
                TestNice.getOutput().log("main", mainMessagesStream.toString());
            }
        }
    }

    public void pass() {
        if (this.isKnownBug) {
            TestNice.increaseFixed();
            this.printSources();
            TestNice.getOutput().logAndFlush("The above known bug is now FIXED!");
        } else {
            TestNice.increaseSucceeded();
        }
        TestNice.getOutput().endTestCase(true);
    }

    public void fail() {
        if (this.isKnownBug) {
            TestNice.increaseKnownBug();
            TestNice.getOutput().endTestCase(true);
        } else {
            TestNice.increaseFailed();
            this.printSources();
            TestNice.getOutput().log("nicec", this.getCompilerMessages());
            TestNice.getOutput().endTestCase(false);
        }
        TestNice.moveFilesToFailFolder();
    }

    public void warning() {
        TestNice.increaseWarning();
        this.printSources();
        TestNice.getOutput().log("nicec", this.getCompilerMessages());
        TestNice.getOutput().endTestCase(false);
        TestNice.moveFilesToFailFolder();
    }

    private void printSources() {
        BufferedWriter writer;
        StringWriter contentWriter;
        for (NiceSourceFile sourceFile : this._niceSourceFiles) {
            contentWriter = new StringWriter();
            writer = new BufferedWriter(contentWriter);
            try {
                String line;
                sourceFile.write(writer);
                contentWriter.close();
                writer.close();
                TestNice.getOutput().log("");
                LineNumberReader lines = new LineNumberReader(new StringReader(contentWriter.toString()));
                String file = "file " + sourceFile.getPackage() + "." + sourceFile.getFileName();
                while ((line = lines.readLine()) != null) {
                    TestNice.getOutput().log(file + ":" + lines.getLineNumber(), line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            TestNice.getOutput().log("");
        }
        if (this._testSuite.hasGlobalSource()) {
            contentWriter = new StringWriter();
            writer = new BufferedWriter(contentWriter);
            try {
                this._testSuite.getGlobalSource().write(writer);
                contentWriter.close();
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            TestNice.getOutput().log("file " + this._testSuite.getGlobalSource().getPackage() + "." + this._testSuite.getGlobalSource().getFileName(), contentWriter.toString());
            TestNice.getOutput().log("");
        }
    }

    protected String getCompilerMessages() {
        return this._compilerMessagesStream.toString();
    }

    protected class FailPosition {
        private String _fileName;
        private int _line;
        private int _column;
        private NiceSourceFile _sourceFile;
        private boolean _inMain;

        FailPosition(String fileName, int line, int column, NiceSourceFile sourceFile, boolean inMain) {
            this._fileName = fileName;
            this._line = line;
            this._column = column;
            this._sourceFile = sourceFile;
            this._inMain = inMain;
        }

        protected String getFileName() {
            return this._fileName;
        }

        protected int getLine() {
            int res = this._line;
            res = this._inMain ? (res += this._sourceFile.getTopLevelSectionLength() + 2) : (res -= this._sourceFile.getMainSectionLength());
            return res;
        }

        protected int getColumn() {
            return this._column;
        }
    }
}

