/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing;

import java.util.Map;
import mlsub.typing.AtomicConstraint;
import mlsub.typing.TypeConstructor;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;

public final class TypeConstructorLeqCst
extends AtomicConstraint {
    private TypeConstructor t1;
    private TypeConstructor t2;

    public TypeConstructorLeqCst(TypeConstructor t1, TypeConstructor t2) {
        this.t1 = t1;
        this.t2 = t2;
        TypeConstructorLeqCst.identifyVariances(t1, t2);
    }

    private static void identifyVariances(TypeConstructor t1, TypeConstructor t2) {
        if (t1.variance == null && t2.variance != null) {
            t1.setVariance(t2.variance);
        } else if (t2.variance == null && t1.variance != null) {
            t2.setVariance(t1.variance);
        }
    }

    @Override
    AtomicConstraint substitute(Map map2) {
        Object tt1 = map2.get(this.t1);
        Object tt2 = map2.get(this.t2);
        if (tt1 == null && tt2 == null) {
            return this;
        }
        if (tt1 == null) {
            tt1 = this.t1;
        } else if (tt2 == null) {
            tt2 = this.t2;
        }
        return new TypeConstructorLeqCst((TypeConstructor)tt1, (TypeConstructor)tt2);
    }

    @Override
    public void enter() throws TypingEx {
        Typing.leq(this.t1, this.t2);
    }

    public String toString() {
        return this.t1 + " < " + this.t2;
    }

    public TypeConstructor t1() {
        return this.t1;
    }

    public TypeConstructor t2() {
        return this.t2;
    }
}

