/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.text.LineBufferedReader;
import java.io.PrintWriter;

public class SourceError {
    public SourceError next;
    public char severity;
    public String filename;
    public int line;
    public int column;
    public String message;

    public SourceError(char severity, String filename, int line, int column, String message) {
        this.severity = severity;
        this.filename = filename;
        this.line = line;
        this.column = column;
        this.message = message;
    }

    public SourceError(LineBufferedReader port, char severity, String message) {
        this(severity, port.getName(), port.getLineNumber() + 1, port.getColumnNumber(), message);
        if (this.column >= 0) {
            ++this.column;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.filename == null ? "<unknown>" : this.filename);
        buffer.append(':');
        buffer.append(this.line);
        if (this.column > 0) {
            buffer.append(':');
            buffer.append(this.column);
        }
        buffer.append(": ");
        if (this.severity == 'w') {
            buffer.append("warning - ");
        }
        buffer.append(this.message);
        return buffer.toString();
    }

    public void print(PrintWriter out) {
        out.print(this);
    }
}

