/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class TtyInPort
extends InPort {
    protected OutPort tie;
    private Procedure prompter;
    private boolean promptEmitted;

    public Procedure getPrompter() {
        return this.prompter;
    }

    public void setPrompter(Procedure prompter) {
        this.prompter = prompter;
    }

    public TtyInPort(InputStream in, String name, OutPort tie) {
        super(in, name);
        this.setConvertCR(true);
        this.tie = tie;
    }

    public TtyInPort(Reader in, String name, OutPort tie) {
        super(in, name);
        this.setConvertCR(true);
        this.tie = tie;
    }

    @Override
    public int fill(int len) throws IOException {
        int count = this.in.read(this.buffer, this.pos, len);
        if (this.tie != null && count > 0) {
            this.tie.echo(this.buffer, this.pos, count);
        }
        return count;
    }

    @Override
    public void lineStart(boolean revisited) throws IOException {
        if (!revisited && this.prompter != null) {
            try {
                String string;
                this.tie.freshLine();
                Object prompt = this.prompter.apply1(this);
                if (prompt != null && (string = prompt.toString()) != null && string.length() > 0) {
                    this.tie.print(string);
                    this.tie.flush();
                    this.tie.clearBuffer();
                    this.promptEmitted = true;
                }
            }
            catch (Throwable ex) {
                throw new IOException("Error when evaluating prompt:" + ex);
            }
        }
    }

    @Override
    public int read() throws IOException {
        int ch;
        if (this.tie != null) {
            this.tie.flush();
        }
        if ((ch = super.read()) < 0 && this.promptEmitted & this.tie != null) {
            this.tie.println();
        }
        this.promptEmitted = false;
        return ch;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int count;
        if (this.tie != null) {
            this.tie.flush();
        }
        if ((count = super.read(cbuf, off, len)) < 0 && this.promptEmitted & this.tie != null) {
            this.tie.println();
        }
        this.promptEmitted = false;
        return count;
    }
}

