/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.PositionContainer;
import gnu.lists.SeqPosition;
import gnu.lists.Sequence;
import gnu.lists.SubSequence;
import gnu.lists.TreePosition;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractSequence {
    public abstract int size();

    public boolean isEmpty() {
        return this.size() > 0;
    }

    public int rank() {
        return 1;
    }

    public abstract Object get(int var1);

    public int getEffectiveIndex(int[] indexes) {
        return indexes[0];
    }

    public Object get(int[] indexes) {
        return this.get(indexes[0]);
    }

    public Object set(int[] indexes, Object value) {
        return this.set(indexes[0], value);
    }

    protected RuntimeException unsupported(String text) {
        text = this.getClass().getName() + " does not implement " + text;
        return new UnsupportedOperationException(text);
    }

    public Object set(int index, Object element) {
        throw this.unsupported("set");
    }

    public void fill(Object value) {
        SeqPosition it = this.getIterator();
        while (this.gotoNext(it)) {
            this.setPrevious(it.ipos, it.xpos, value);
        }
        it.finalize();
    }

    public void fill(int fromIndex, int toIndex, Object value) {
        for (int i = fromIndex; i < toIndex; ++i) {
            this.set(i, value);
        }
    }

    public int indexOf(Object o) {
        int i = 0;
        SeqPosition it = this.getIterator();
        while (it.hasNext()) {
            Object e = it.next();
            if (o == null ? e == null : o.equals(e)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        int n = this.size();
        while (--n >= 0) {
            Object e = this.get(n);
            if (!(o == null ? e == null : o.equals(e))) continue;
            return n;
        }
        return -1;
    }

    public boolean contains(Object o) {
        SeqPosition i = this.getIterator();
        while (i.hasNext()) {
            Object e = i.next();
            if (!(o == null ? e == null : o.equals(e))) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection c) {
        SeqPosition i = this.getIterator();
        while (i.hasNext()) {
            Object e = i.next();
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    public Enumeration elements() {
        SeqPosition it = new SeqPosition();
        this.makeStartPosition(it);
        return it;
    }

    public SeqPosition getIterator() {
        SeqPosition it = new SeqPosition();
        this.makeStartPosition(it);
        return it;
    }

    public Iterator iterator() {
        SeqPosition it = new SeqPosition();
        this.makeStartPosition(it);
        return it;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) {
        SeqPosition it = new SeqPosition();
        this.makePosition(index, it);
        return it;
    }

    protected void add(PositionContainer posSet, int posNumber, Object value) {
        throw this.unsupported("add");
    }

    public boolean add(Object o) {
        this.add(this.size(), o);
        return true;
    }

    public void add(int index, Object o) {
        throw this.unsupported("add single Object at index");
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size(), c);
    }

    public boolean addAll(int index, Collection c) {
        boolean changed = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(index++, it.next());
            changed = true;
        }
        return changed;
    }

    protected void remove(int ipos, Object xpos, int count) {
        SeqPosition it = new SeqPosition(this);
        this.makeRelativePosition(ipos, xpos, count, true, it, 0);
        if (count >= 0) {
            this.remove(ipos, xpos, it.ipos, it.xpos);
        } else {
            this.remove(it.ipos, it.xpos, ipos, xpos);
        }
    }

    protected void remove(int ipos0, Object xpos0, int ipos1, Object xpos1) {
        throw this.unsupported("remove (with range)");
    }

    public Object remove(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        SeqPosition it = new SeqPosition(this);
        this.makePosition(index, it);
        Object result = this.getNext(it.ipos, it.xpos);
        this.remove(it.ipos, it.xpos, 1);
        return result;
    }

    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index < 0) {
            return false;
        }
        SeqPosition it = new SeqPosition();
        this.makePosition(index, it);
        this.remove(it.ipos, it.xpos, 1);
        return true;
    }

    public boolean removeAll(Collection c) {
        boolean changed = false;
        SeqPosition it = this.getIterator();
        while (it.hasNext()) {
            Object value = it.next();
            if (!c.contains(value)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    public boolean retainAll(Collection c) {
        boolean changed = false;
        SeqPosition it = this.getIterator();
        while (it.hasNext()) {
            Object value = it.next();
            if (c.contains(value)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    public void clear() {
        SeqPosition it = new SeqPosition();
        this.makeStartPosition(it);
        this.remove(it.ipos, it.xpos, this.size());
    }

    protected boolean isAfter(int ipos, Object xpos) {
        return false;
    }

    protected final void makePosition(int index, SeqPosition pos) {
        this.makePosition(index, true, pos);
    }

    public void makePosition(int index, boolean isAfter, SeqPosition pos) {
        this.makePosition(index, isAfter, pos, 0);
    }

    protected abstract void makePosition(int var1, boolean var2, PositionContainer var3, int var4);

    protected void makeRelativePosition(int istart, Object xstart, int offset, boolean isAfter, PositionContainer posSet, int posNumber) {
        this.makePosition(this.nextIndex(istart, xstart) + offset, isAfter, posSet, posNumber);
    }

    public void makeStartPosition(SeqPosition pos) {
        this.makeStartPosition(pos, 0);
    }

    protected void makeStartPosition(PositionContainer poses, int positionNumber) {
        this.makePosition(0, false, poses, positionNumber);
    }

    public void makeEndPosition(SeqPosition pos) {
        this.makeEndPosition(pos, 0);
        pos.setSequence(0, this);
    }

    protected void makeEndPosition(PositionContainer poses, int positionNumber) {
        this.makePosition(this.size(), true, poses, positionNumber);
    }

    protected void releasePosition(int ipos, Object xpos) {
    }

    protected final void releasePosition(SeqPosition pos) {
        this.releasePosition(pos.ipos, pos.xpos);
    }

    protected void releasePosition(PositionContainer posSet, int posNumber) {
        int ipos = posSet.getPositionInt(posNumber);
        Object xpos = posSet.getPositionPtr(posNumber);
        this.releasePosition(ipos, xpos);
    }

    public void copyPosition(int ipos, Object xpos, PositionContainer posSet, int posNumber) {
        posSet.setSequence(posNumber, this);
        posSet.setPosition(posNumber, ipos, xpos);
    }

    protected int getIndexDifference(int ipos1, Object xpos1, int ipos0, Object xpos0) {
        return this.nextIndex(ipos1, xpos1) - this.nextIndex(ipos0, xpos0);
    }

    protected int nextIndex(int ipos, Object xpos) {
        throw this.unsupported("nextIndex");
    }

    protected int fromEndIndex(int ipos, Object xpos) {
        return this.size() - this.nextIndex(ipos, xpos);
    }

    protected int getContainingSequenceSize(int ipos, Object xpos) {
        return this.size();
    }

    protected boolean hasNext(int ipos, Object xpos) {
        return this.nextIndex(ipos, xpos) != this.size();
    }

    public int getNextKind(int ipos, Object xpos) {
        return this.hasNext(ipos, xpos) ? 32 : 0;
    }

    public String getNextTypeName(int ipos, Object xpos) {
        return null;
    }

    public Object getNextTypeObject(int ipos, Object xpos) {
        return null;
    }

    protected boolean hasPrevious(int ipos, Object xpos) {
        return this.nextIndex(ipos, xpos) != 0;
    }

    public boolean gotoNext(PositionContainer posSet, int posNumber) {
        Object xpos;
        int ipos = posSet.getPositionInt(posNumber);
        if (!this.hasNext(ipos, xpos = posSet.getPositionPtr(posNumber))) {
            return false;
        }
        this.makeRelativePosition(ipos, xpos, 1, true, posSet, posNumber);
        return true;
    }

    public boolean gotoNext(SeqPosition pos) {
        return this.gotoNext(pos, 0);
    }

    protected boolean gotoPrevious(PositionContainer posSet, int posNumber) {
        Object xpos;
        int ipos = posSet.getPositionInt(posNumber);
        if (!this.hasPrevious(ipos, xpos = posSet.getPositionPtr(posNumber))) {
            return false;
        }
        this.makeRelativePosition(ipos, xpos, -1, false, posSet, posNumber);
        return true;
    }

    public boolean gotoChildrenStart(TreePosition pos) {
        return false;
    }

    protected boolean gotoParent(TreePosition pos) {
        if (pos.depth < 0) {
            return false;
        }
        pos.pop();
        return true;
    }

    public int getAttributeLength() {
        return 0;
    }

    public Object getAttribute(int index) {
        return null;
    }

    protected boolean gotoAttributesStart(TreePosition pos) {
        return false;
    }

    protected Object getNext(int ipos, Object xpos) {
        return this.get(this.nextIndex(ipos, xpos));
    }

    protected Object getPrevious(int ipos, Object xpos) {
        return this.get(this.nextIndex(ipos, xpos) - 1);
    }

    protected void setNext(int ipos, Object xpos, Object value) {
        int index = this.nextIndex(ipos, xpos);
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.set(index, value);
    }

    protected void setPrevious(int ipos, Object xpos, Object value) {
        int index = this.nextIndex(ipos, xpos);
        if (index == 0) {
            throw new IndexOutOfBoundsException();
        }
        this.set(index - 1, value);
    }

    public final int nextIndex(SeqPosition pos) {
        return this.nextIndex(pos.ipos, pos.xpos);
    }

    public boolean equals(int ipos1, Object xpos1, int ipos2, Object xpos2) {
        return this.compare(ipos1, xpos1, ipos2, xpos2) == 0;
    }

    public int compare(int ipos1, Object xpos1, int ipos2, Object xpos2) {
        int i2;
        int i1 = this.nextIndex(ipos1, xpos1);
        return i1 < (i2 = this.nextIndex(ipos2, xpos2)) ? -1 : (i1 > i2 ? 1 : 0);
    }

    public final int compare(SeqPosition i1, SeqPosition i2) {
        return this.compare(i1.ipos, i1.xpos, i2.ipos, i2.xpos);
    }

    public Object[] toArray() {
        int len = this.size();
        Object[] arr = new Object[len];
        Enumeration e = this.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            arr[i] = e.nextElement();
            ++i;
        }
        return arr;
    }

    public Object[] toArray(Object[] arr) {
        int alen = arr.length;
        int len = this.size();
        if (len > alen) {
            Class<?> componentType = arr.getClass().getComponentType();
            arr = (Object[])Array.newInstance(componentType, len);
            alen = len;
        }
        Enumeration e = this.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            arr[i] = e.nextElement();
            ++i;
        }
        if (len < alen) {
            arr[len] = null;
        }
        return arr;
    }

    public int hashCode() {
        int hash = 1;
        SeqPosition i = this.getIterator();
        while (i.hasNext()) {
            Object obj = i.next();
            hash = 31 * hash + (obj == null ? 0 : obj.hashCode());
        }
        return hash;
    }

    public boolean equals(Object o) {
        Object e2;
        Object e1;
        if (!(o instanceof List)) {
            return false;
        }
        Iterator it1 = this.iterator();
        Iterator it2 = ((List)o).iterator();
        do {
            boolean more2;
            boolean more1;
            if ((more1 = it1.hasNext()) != (more2 = it2.hasNext())) {
                return false;
            }
            if (!more1) {
                return true;
            }
            e1 = it1.next();
            e2 = it2.next();
        } while (!(e1 == null ? e2 != null : !e1.equals(e2)));
        return false;
    }

    public Sequence subSequence(SeqPosition start, SeqPosition end) {
        return this.subSequence(start.ipos, start.xpos, end.ipos, end.xpos);
    }

    protected Sequence subSequence(int ipos0, Object xpos0, int ipos1, Object xpos1) {
        SubSequence sub = new SubSequence(this);
        this.copyPosition(ipos0, xpos0, sub, 0);
        this.copyPosition(ipos1, xpos1, sub, 1);
        return sub;
    }

    public List subList(int fromIx, int toIx) {
        SubSequence sub = new SubSequence(this);
        this.makePosition(fromIx, false, sub, 0);
        this.makePosition(toIx, true, sub, 1);
        return sub;
    }

    public boolean consumeNext(int ipos, Object xpos, Consumer out) {
        if (!this.hasNext(ipos, xpos)) {
            return false;
        }
        out.writeObject(this.getNext(ipos, xpos));
        return true;
    }

    protected void consume(int iposStart, Object xposStart, int iposEnd, Object xposEnd, Consumer out) {
        if (out.ignoring()) {
            return;
        }
        SeqPosition it = new SeqPosition();
        this.copyPosition(iposStart, xposStart, it, 0);
        while (!this.equals(it.ipos, it.xpos, iposEnd, xposEnd)) {
            if (!it.hasNext()) {
                throw new RuntimeException();
            }
            out.writeObject(it.nextElement());
        }
        it.finalize();
    }

    public void consume(Consumer out) {
        String typeName;
        String type = typeName = "#sequence";
        out.beginGroup(typeName, type);
        Enumeration e = this.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            out.writeObject(e.nextElement());
            ++i;
        }
        out.endGroup(typeName);
    }
}

