/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.SwitchState;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.bytecode.VerificationError;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.WrongArguments;
import java.util.Stack;

public class ApplyExp
extends Expression {
    Expression func;
    Expression[] args;
    boolean tailCall;
    boolean special;
    LambdaExp context;
    public ApplyExp nextCall;

    public final Expression getFunction() {
        return this.func;
    }

    public final Expression[] getArgs() {
        return this.args;
    }

    public final int getArgCount() {
        return this.args.length;
    }

    public void setArgs(Expression[] args) {
        this.args = args;
    }

    public final boolean isTailCall() {
        return this.tailCall;
    }

    public final void setTailCall(boolean tailCall) {
        this.tailCall = tailCall;
    }

    public ApplyExp(Expression f, Expression[] a) {
        this(f, a, false);
    }

    public ApplyExp(Expression f, Expression[] a, boolean special) {
        this.func = f;
        this.args = a;
        this.special = special;
    }

    public ApplyExp(Procedure p, Expression[] a) {
        this.func = new QuoteExp(p);
        this.args = a;
    }

    public ApplyExp(Method m, Expression[] a) {
        this.func = new QuoteExp(new PrimProcedure(m));
        this.args = a;
    }

    @Override
    public Object eval(Environment env) throws Throwable {
        Procedure proc = (Procedure)this.func.eval(env);
        int n = this.args.length;
        Object[] vals = new Object[n];
        for (int i = 0; i < n; ++i) {
            vals[i] = this.args[i].eval(env);
        }
        return proc.applyN(vals);
    }

    @Override
    public void eval(Environment env, CallContext ctx) throws Throwable {
        Procedure proc = (Procedure)this.func.eval(env);
        int n = this.args.length;
        Object[] vals = new Object[n];
        for (int i = 0; i < n; ++i) {
            vals[i] = this.args[i].eval(env);
        }
        ctx.setArgsN(vals);
        ctx.proc = proc;
    }

    public static void compileToArray(Expression[] args, Compilation comp) {
        CodeAttr code = comp.getCode();
        if (args.length == 0) {
            code.emitGetStatic(Compilation.noArgsField);
            return;
        }
        LambdaExp caller = comp.curLambda;
        code.emitPushInt(args.length);
        code.emitNewArray(Type.pointer_type);
        for (int i = 0; i < args.length; ++i) {
            Expression arg = args[i];
            if (Compilation.usingCPStyle && !(arg instanceof QuoteExp) && !(arg instanceof ReferenceExp)) {
                arg.compile(comp, Target.pushObject);
                code.emitSwap();
                code.emitDup(1, 1);
                code.emitSwap();
                code.emitPushInt(i);
                code.emitSwap();
            } else {
                code.emitDup(Compilation.objArrayType);
                code.emitPushInt(i);
                arg.compile(comp, Target.pushObject);
            }
            code.emitArrayStore(Type.pointer_type);
        }
    }

    @Override
    public void compile(Compilation comp, Target target) {
        try {
            ApplyExp.compile(this, comp, target, true);
        }
        catch (VerificationError e) {
            throw User.error((Located)Location.make(this), e.getMessage());
        }
    }

    public static void compile(ApplyExp exp, Compilation comp, Target target) {
        ApplyExp.compile(exp, comp, target, false);
    }

    static void compile(ApplyExp exp, Compilation comp, Target target, boolean checkInlineable) {
        boolean toArray;
        boolean tail_recurse;
        Method method;
        Object proc;
        int args_length = exp.args.length;
        Expression exp_func = exp.func;
        LambdaExp func_lambda = null;
        String func_name = null;
        if (exp_func instanceof LambdaExp) {
            func_lambda = (LambdaExp)exp_func;
            func_name = func_lambda.getName();
            if (func_name == null) {
                func_name = "<lambda>";
            }
        } else if (exp_func instanceof ReferenceExp) {
            Declaration func_decl = ((ReferenceExp)exp_func).binding;
            if (!func_decl.getFlag(65536)) {
                Expression value = func_decl.getValue();
                func_name = func_decl.getName();
                if (value != null && value instanceof LambdaExp) {
                    func_lambda = (LambdaExp)value;
                }
                if (value != null && value instanceof QuoteExp) {
                    Procedure proc2;
                    Object quotedValue = ((QuoteExp)value).getValue();
                    String msg = null;
                    if (!(quotedValue instanceof Procedure)) {
                        proc2 = null;
                        msg = "calling " + func_name + " which is not a procedure";
                    } else {
                        if (checkInlineable && quotedValue instanceof Inlineable) {
                            ((Inlineable)quotedValue).compile(exp, comp, target);
                            return;
                        }
                        proc2 = (Procedure)quotedValue;
                        msg = WrongArguments.checkArgCount(proc2, args_length);
                    }
                    if (msg != null) {
                        comp.error('w', msg);
                    } else {
                        PrimProcedure pproc = PrimProcedure.getMethodFor(proc2, func_decl, exp.args, comp.getInterpreter());
                        if (pproc != null) {
                            if (!pproc.getStaticFlag()) {
                                func_decl.base.load(comp);
                            }
                            pproc.compile(null, exp.args, comp, target);
                            return;
                        }
                    }
                }
            }
        } else if (exp_func instanceof QuoteExp && (proc = ((QuoteExp)exp_func).getValue()) instanceof Inlineable) {
            if (checkInlineable) {
                ((Inlineable)proc).compile(exp, comp, target);
                return;
            }
            PrimProcedure pproc = PrimProcedure.getMethodFor((Procedure)proc, exp.args);
            if (pproc != null) {
                exp = new ApplyExp(pproc, exp.args);
                pproc.compile(exp, comp, target);
                return;
            }
        }
        CodeAttr code = comp.getCode();
        if (func_lambda != null) {
            String msg = null;
            if (func_lambda.isClassMethod()) {
                --args_length;
            }
            if (args_length < func_lambda.min_args) {
                msg = "too few args for ";
            } else if (func_lambda.max_args >= 0 && args_length > func_lambda.max_args) {
                msg = "too many args " + args_length + " for ";
            } else if (!func_lambda.isHandlingTailCalls() && (method = func_lambda.getMethod(args_length)) != null) {
                boolean varArgs;
                boolean is_static = method.getStaticFlag();
                Expression[] args = exp.getArgs();
                int extraArg = 0;
                Type[] argTypes = method.getParameterTypes();
                if (func_lambda.declareClosureEnv() != null) {
                    if (is_static) {
                        extraArg = 1;
                    }
                    if (comp.curLambda == func_lambda) {
                        code.emitLoad(func_lambda.closureEnv);
                    } else {
                        func_lambda.getHeapLambda().loadHeapFrame(comp);
                    }
                }
                boolean bl = varArgs = func_lambda.restArgType() != null;
                PrimProcedure.compileArgs(args, func_lambda.isClassMethod() ? method.getDeclaringClass() : (extraArg > 0 ? Type.void_type : null), argTypes, varArgs, func_name, func_lambda, comp);
                if (exp.special) {
                    code.emitInvokeSpecial(method);
                } else {
                    code.emitInvoke(method);
                }
                target.compileFromStack(comp, func_lambda.getReturnType());
                return;
            }
            if (msg != null) {
                comp.error('w', msg + func_name);
                func_lambda = null;
            }
        }
        if (comp.usingCPStyle()) {
            Field fld;
            int i;
            Label l = new Label(code);
            SwitchState fswitch = comp.fswitch;
            int pc = fswitch.getMaxValue() + 1;
            fswitch.addCase(pc, l, code);
            exp_func.compile(comp, new StackTarget(Compilation.typeProcedure));
            code.emitLoad(comp.callStackContext);
            code.emitLoad(comp.callStackContext);
            code.emitPushInt(pc);
            code.emitPutField(Compilation.pcCallContextField);
            code.emitInvokeVirtual(Compilation.applyCpsMethod);
            Type[] stackTypes = code.saveStackTypeState(false);
            Stack<Field> stackFields = new Stack<Field>();
            if (stackTypes != null) {
                i = stackTypes.length;
                while (--i >= 0) {
                    fld = comp.allocLocalField(stackTypes[i], null);
                    code.emitPushThis();
                    code.emitSwap();
                    code.emitPutField(fld);
                    stackFields.push(fld);
                }
            }
            code.emitReturn();
            l.define(code);
            if (stackTypes != null) {
                i = stackTypes.length;
                while (--i >= 0) {
                    fld = (Field)stackFields.pop();
                    code.emitPushThis();
                    code.emitGetField(fld);
                    comp.freeLocalField(fld);
                }
            }
            return;
        }
        boolean bl = tail_recurse = exp.tailCall && func_lambda != null && func_lambda == comp.curLambda;
        if (func_lambda != null && func_lambda.getInlineOnly() && !tail_recurse && func_lambda.min_args == args_length) {
            Declaration param = func_lambda.firstDecl();
            for (int i = 0; i < args_length; ++i) {
                exp.args[i].compile(comp, param.getType());
                param = param.nextDecl();
            }
            LambdaExp saveLambda = comp.curLambda;
            comp.curLambda = func_lambda;
            func_lambda.allocChildClasses(comp);
            func_lambda.allocParameters(comp);
            ApplyExp.popParams(code, func_lambda, false);
            func_lambda.enterFunction(comp);
            func_lambda.body.compileWithPosition(comp, target);
            func_lambda.compileEnd(comp);
            func_lambda.compileChildMethods(comp);
            comp.curLambda = saveLambda;
            return;
        }
        if (comp.curLambda != null && comp.curLambda.isHandlingTailCalls() && !comp.curLambda.getInlineOnly()) {
            ClassType typeContext = Compilation.typeCallContext;
            exp_func.compile(comp, new StackTarget(Compilation.typeProcedure));
            code.emitLoad(comp.callStackContext);
            code.emitDupX();
            if (!exp.isTailCall()) {
                code.emitDupX();
            }
            if (args_length <= 4) {
                for (int i = 0; i < args_length; ++i) {
                    exp.args[i].compile(comp, Target.pushObject);
                }
                code.emitInvoke(typeContext.getDeclaredMethod("setArgs", args_length));
            } else {
                ApplyExp.compileToArray(exp.args, comp);
                code.emitInvoke(typeContext.getDeclaredMethod("setArgsN", 1));
            }
            if (exp.isTailCall()) {
                code.emitPutField(Compilation.procCallContextField);
                code.emitReturn();
            } else if (target instanceof ConsumerTarget) {
                code.emitPutField(Compilation.procCallContextField);
                code.emitLoad(((ConsumerTarget)target).getConsumerVariable());
                code.emitInvoke(typeContext.getDeclaredMethod("runUntilValue", 1));
            } else {
                code.emitPutField(Compilation.procCallContextField);
                code.emitInvoke(typeContext.getDeclaredMethod("runUntilValue", 0));
                target.compileFromStack(comp, Type.pointer_type);
            }
            return;
        }
        if (!tail_recurse) {
            exp_func.compile(comp, new StackTarget(Compilation.typeProcedure));
        }
        boolean bl2 = tail_recurse ? func_lambda.min_args != func_lambda.max_args : (toArray = args_length > 4);
        if (toArray) {
            ApplyExp.compileToArray(exp.args, comp);
            method = Compilation.applyNmethod;
        } else if (tail_recurse) {
            Declaration param = func_lambda.firstDecl();
            for (int i = 0; i < args_length; ++i) {
                exp.args[i].compile(comp, param.getType());
                param = param.nextDecl();
            }
            method = null;
        } else {
            for (int i = 0; i < args_length; ++i) {
                exp.args[i].compile(comp, Target.pushObject);
            }
            method = Compilation.applymethods[args_length];
        }
        if (tail_recurse) {
            ApplyExp.popParams(code, func_lambda, toArray);
            code.emitTailCall(false, func_lambda.scope);
            return;
        }
        code.emitInvokeVirtual(method);
        target.compileFromStack(comp, Type.pointer_type);
    }

    @Override
    protected Expression walk(ExpWalker walker) {
        return walker.walkApplyExp(this);
    }

    @Override
    protected void walkChildren(ExpWalker walker) {
        this.func = this.func.walk(walker);
        if (walker.exitValue == null) {
            this.args = walker.walkExps(this.args);
        }
    }

    @Override
    public void print(OutPort out) {
        out.startLogicalBlock("(Apply", ")", 2);
        if (this.tailCall) {
            out.print(" [tailcall]");
        }
        out.writeSpaceFill();
        this.printLineColumn(out);
        this.func.print(out);
        for (int i = 0; i < this.args.length; ++i) {
            out.writeSpaceLinear();
            this.args[i].print(out);
        }
        out.endLogicalBlock(")");
    }

    private static void popParams(CodeAttr code, LambdaExp lexp, boolean toArray) {
        Variable params = lexp.scope.firstVar();
        if (params != null && params.getName() == "this") {
            params = params.nextVar();
        }
        if (params != null && params.getName() == "$ctx") {
            params = params.nextVar();
        }
        if (params != null && params.getName() == "argsArray") {
            if (toArray) {
                ApplyExp.popParams(code, params, 1);
                return;
            }
            params = params.nextVar();
        }
        ApplyExp.popParams(code, params, lexp.min_args);
    }

    private static void popParams(CodeAttr code, Variable vars, int count) {
        if (count > 0) {
            ApplyExp.popParams(code, vars.nextVar(), count - 1);
            code.emitStore(vars);
        }
    }

    @Override
    public final Type getType() {
        Object proc;
        Declaration func_decl;
        Expression afunc = this.func;
        if (afunc instanceof ReferenceExp && (func_decl = ((ReferenceExp)afunc).binding) != null && !func_decl.getFlag(65536)) {
            afunc = func_decl.getValue();
        }
        if (afunc instanceof QuoteExp && (proc = ((QuoteExp)afunc).getValue()) instanceof Inlineable) {
            return ((Inlineable)proc).getReturnType(this.args);
        }
        if (afunc instanceof LambdaExp) {
            return ((LambdaExp)afunc).getReturnType();
        }
        return super.getType();
    }

    public static Expression inlineIfConstant(Procedure proc, ApplyExp exp) {
        int len;
        int i = len = exp.args.length;
        while (--i >= 0) {
            if (exp.args[i] instanceof QuoteExp) continue;
            return exp;
        }
        Object[] vals = new Object[len];
        int i2 = len;
        while (--i2 >= 0) {
            vals[i2] = ((QuoteExp)exp.args[i2]).getValue();
        }
        try {
            return new QuoteExp(proc.applyN(vals));
        }
        catch (Throwable ex) {
            return null;
        }
    }
}

