module Prelude(RealFloat(..)) where

import PrimDecodeDouble
import PrimEncodeDouble
import CRealFloat


-- WARNING 64bit IEEE float

instance  RealFloat Double  where
    floatRadix _  = 2          -- FLT_RADIX
    floatDigits _ = 53         -- DBL_DIGITS
    floatRange _  = (negate 1073,1024) -- (DBL_MINEXP, DBL_MAXEXP)
    decodeFloat x = primDecodeDouble x
    encodeFloat x y = primEncodeDouble x y

    -- TODO
    isNaN x          = cDIsNaN x
    isInfinite x     = not (cDIsFinite x)
    isDenormalized x = not (cDIsNormal x)
    isNegativeZero x = cDIsNeg x && (x==0.0)
    isIEEE x         = True

foreign import noproto "math.h isnan"    cDIsNaN    :: Double -> Bool
foreign import noproto "math.h isfinite" cDIsFinite :: Double -> Bool
foreign import noproto "math.h isnormal" cDIsNormal :: Double -> Bool
foreign import noproto "math.h signbit"  cDIsNeg    :: Double -> Bool
