/*

Copyright (C) 2000 - 2010 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <nd_fam.h>
#include <nd_prefs.h>
#include <nd_plugin.h>

#ifndef HAVE_LIBFAM
void nd_fam_init(void) { }
void nd_fam_shutdown(void) { }
#else
#include <fam.h>

static FAMConnection fam_con;
static FAMRequest    fam_global_plugin_dir_req;
static FAMRequest    fam_user_plugin_dir_req;
static int           fam_gdk_tag;
static gboolean      fam_pending;
static gboolean      fam_initialized;

static void fam_change_cb(void *user_data, gint fd, GdkInputCondition condition);

static gint 
fam_change_timeout(gpointer data)
{
  nd_plugin_init();
  fam_pending = FALSE;

  return FALSE;
  TOUCH(data);
}


static void
fam_change_cb(void *user_data, gint fd, GdkInputCondition condition)
{
  FAMEvent     fam_ev;
  gboolean     event_seen = FALSE;

  while (FAMPending(&fam_con) > 0)
    {
      memset(&fam_ev, 0, sizeof(FAMEvent));
      
      if (FAMNextEvent(&fam_con, &fam_ev) < 0)
	{
	  nd_fam_shutdown();
	  nd_fam_init();
	  D_RETURN;
	}

      event_seen = TRUE;
   }

  if (event_seen && !fam_pending && fam_ev.code == FAMChanged)
    {
      D(("FAM triggered plugin reload\n"));
      fam_pending = TRUE;
      gtk_timeout_add(5000, fam_change_timeout, NULL);
    }
  
  return;
  TOUCH(user_data);
  TOUCH(fd);
  TOUCH(condition);
}


void 
nd_fam_init(void)
{
  D_ENTER;

  if (! nd_runtime_options.use_fam)
    D_RETURN;

  if (FAMOpen(&fam_con) != 0)
    {
      D(("FAM setup failed, error code %i\n", FAMErrno));
      D_RETURN;
    }

  fam_initialized = TRUE;

  FAMMonitorDirectory(&fam_con,
		      nd_prefs_get_plugin_dir_global(),
		      &fam_global_plugin_dir_req,
		      NULL);

  FAMMonitorDirectory(&fam_con,
		      nd_prefs_get_plugin_dir_user(),
		      &fam_user_plugin_dir_req,
		      NULL);

  fam_gdk_tag = gdk_input_add(FAMCONNECTION_GETFD(&fam_con), GDK_INPUT_READ,
			      (GdkInputFunction) fam_change_cb, NULL);

  D_RETURN;
}


void 
nd_fam_shutdown(void)
{
  if (!fam_initialized)
    return;

  if (FAMCONNECTION_GETFD(&fam_con))
    {      
      FAMCancelMonitor(&fam_con, &fam_global_plugin_dir_req);
      FAMCancelMonitor(&fam_con, &fam_user_plugin_dir_req);
      
      gdk_input_remove(fam_gdk_tag);
    }
}

#endif

