/*

Copyright (C) 2000 - 2010 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <nd.h>
#include <nd_gui.h>
#include <nd_packet.h>
#include <nd_dialog.h>

#include <nd_vlan.h>
#include <nd_vlan_callbacks.h>


void   
nd_vlan_tci_cb(LND_Packet  *packet,
	       guchar      *header,
	       guchar      *data)
{
  ND_ProtoCallbackData *cb_data;
  struct lnd_vlan_header *vh;

  vh = (struct lnd_vlan_header *) header;
  cb_data = nd_proto_cb_data_new(nd_vlan_get(), data, data-header, TRUE);
  
  nd_dialog_number(_("Enter 16-bit TCI value:"),
		   ND_BASE_DEC,
		   ntohs(vh->vlan_tci), 65535,
		   nd_proto_iterate_16bit_cb,
		   NULL,
		   packet, cb_data);
}


/* The callback that gets called when the user has clicked
   one of the predefined Ethernet protocol values: */
void    
nd_vlan_proto_value_cb(LND_Packet  *packet,
		       guchar      *header,
		       int          value)
{
  LND_Trace            *trace;
  LND_PacketIterator    pit;
  int                   nesting;
  struct lnd_vlan_header *vh;

  if (! (trace = libnd_packet_get_trace(packet)))
    return;

  nesting = libnd_packet_get_proto_nesting(packet, nd_vlan_get(), header);
  if (nesting < 0)
    return;

  for (libnd_pit_init(&pit, trace); libnd_pit_get(&pit); libnd_pit_next(&pit))
    {
      vh = (struct lnd_vlan_header *) libnd_packet_get_data(libnd_pit_get(&pit), nd_vlan_get(), nesting);
      if (!vh)
	continue;
      
      vh->vlan_proto = htons(value);
      libnd_packet_update(libnd_pit_get(&pit), nd_vlan_get(), nesting);
      libnd_packet_modified(libnd_pit_get(&pit));
    }
}


/* The callback that gets called when the user selected "Custom"
   from the VLAN protocol type menu: */
void    
nd_vlan_proto_custom_cb(LND_Packet  *packet,
			guchar      *header,
			int          value)
{
  struct lnd_vlan_header *vh;
  
  vh = (struct lnd_vlan_header *) header;
  nd_dialog_number(_("Enter protocol number:"),
		   ND_BASE_DEC,
		   ntohs(vh->vlan_proto),
		   65535,
		   (ND_NumberCallback) nd_vlan_proto_value_cb,
		   NULL,
		   packet, header);
  
  return;
  TOUCH(value);
}


/* The callback that gets called when the user clicks the button
   for the Ethernet protocol type in the table. Pops up the menu. */
void
nd_vlan_proto_cb(LND_Packet  *packet,
		 guchar      *header,
		 guchar      *data)
{
  static GtkWidget *menu = NULL;

  if (!menu)
    menu = nd_gui_create_menu(vlan_menu_type_data);

  gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, 0, 0);
      
  return;
  TOUCH(header);
  TOUCH(packet);
  TOUCH(data);
}
