/*

Copyright (C) 2000 - 2003 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_udp_h
#define __nd_udp_h

#include <nd.h>

#include <protocols/udp/libnd_udp.h>

#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#ifdef BSD_HOST
#include <netinet/ip_var.h>
#endif

/* These are the implementations of ND_Protocol's callbacks: */
GtkWidget *nd_udp_create_gui(LND_Trace *trace, LND_ProtoInfo *pinf);
void       nd_udp_set_gui(const LND_Packet *packet, LND_ProtoInfo *pinf);

/* Generic accessor function for the protocol implementation: */
LND_Protocol *nd_udp_get(void);
ND_Protocol  *nd_udp_get_gui(void);

guint16    nd_udp_checksum(const LND_Packet *packet);
gboolean   nd_udp_csum_correct(const LND_Packet *packet, guint16 *correct_sum);

/* Helper functions to set a trace's GUI table to a packet's content: */
void       nd_udp_set_gui_sport(LND_ProtoInfo *pinf, struct udphdr *udphdr);
void       nd_udp_set_gui_dport(LND_ProtoInfo *pinf, struct udphdr *udphdr);
void       nd_udp_set_gui_len(LND_ProtoInfo *pinf, struct udphdr *udphdr);
void       nd_udp_set_gui_csum(LND_ProtoInfo *pinf, struct udphdr *udphdr, const LND_Packet *packet);

#endif
