/*

Copyright (C) 2000 - 2010 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <nd.h>
#include <nd_prefs.h>
#include <nd_gui.h>
#include <nd_trace_registry.h>
#include "nd_tcp.h"
#include "nd_tcp_prefs.h"
#include "interface.h"

static GtkWidget *prefs;


static void
tcp_prefs_refresh_trace(LND_Trace *trace, void *user_data)
{
  D(("Refreshing %s\n", trace->filename));

  libnd_tcp_free_state(trace);
  libnd_tcp_init_state(trace);
  libnd_tcpdump_close(trace);
  libnd_tcpdump_open(trace);

  if (libnd_tcp_get_state_mode() == LND_TCP_STATE_UPDATE_ALL)
    {
      LND_PacketIterator     pit;

      D(("Refreshing TCP state for all packets\n"));
      for (libnd_pit_init_mode(&pit, trace, LND_PACKET_IT_PART_R); libnd_pit_get(&pit); libnd_pit_next(&pit))
	libnd_tcp_update_state(libnd_pit_get(&pit), libnd_pit_get_count(&pit));	  
    }

  return;
  TOUCH(user_data);
}


static void
tcp_prefs_apply_cb(LND_PrefsDomain *domain, void *user_data)
{
  if (libnd_tcp_get_state_mode() != libnd_tcp_get_old_state_mode())
    nd_trace_registry_foreach(tcp_prefs_refresh_trace, NULL);

  return;
  TOUCH(domain);
  TOUCH(user_data);
}


void      
nd_tcp_init_prefs(void)
{
  GtkWidget *gui;

  if (!prefs)
    {
      LND_PrefsDomain *domain;

      prefs = create_prefs_window();
      
      ND_GTK_GET(gui, prefs, "tcp_gui");
      gtk_container_remove(GTK_CONTAINER(prefs), gui);
      
      if (! (domain = libnd_prefs_get_domain("TCP")))
	return;

      /* Hook our GUI into the preferences dialog. We don't need to
       * do *anything* in order to extract the values from the dialog
       * when the user clicks the OK or Apply buttons, Netdude does that
       * for us.
       */
      nd_prefs_add_domain_gui(domain, prefs, gui);

      /* We do however need to register a callback so that when the
       * settings get updated, we refresh our traces!
       */
      libnd_prefs_domain_add_apply_cb(domain, tcp_prefs_apply_cb);
    }
}

