/*

Copyright (C) 2000 - 2003 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef __nd_tcp_callbacks_h
#define __nd_tcp_callbacks_h

#include <nd.h>

/* Button callbacks */

void    nd_tcp_sport_cb(LND_Packet  *packet,
			guchar      *header,
			guchar      *data);

void    nd_tcp_dport_cb(LND_Packet  *packet,
			guchar      *header,
			guchar      *data);

void    nd_tcp_seq_cb(LND_Packet  *packet,
		      guchar      *header,
			 guchar      *data);

void    nd_tcp_ack_cb(LND_Packet  *packet,
		      guchar      *header,
		      guchar      *data);

void    nd_tcp_off_cb(LND_Packet  *packet,
		      guchar      *header,
		      guchar      *data);

void    nd_tcp_unused_cb(LND_Packet  *packet,
			 guchar      *header,
			 guchar      *data);

void    nd_tcp_u_cb(LND_Packet  *packet,
		    guchar      *header,
		    guchar      *data);

void    nd_tcp_a_cb(LND_Packet  *packet,
		    guchar      *header,
		    guchar      *data);

void    nd_tcp_p_cb(LND_Packet  *packet,
		    guchar      *header,
		    guchar      *data);

void    nd_tcp_r_cb(LND_Packet  *packet,
		    guchar      *header,
		    guchar      *data);

void    nd_tcp_s_cb(LND_Packet  *packet,
		    guchar      *header,
		    guchar      *data);

void    nd_tcp_f_cb(LND_Packet  *packet,
		    guchar      *header,
		    guchar      *data);

void    nd_tcp_win_cb(LND_Packet  *packet,
		      guchar      *header,
		      guchar      *data);

void    nd_tcp_cksum_cb(LND_Packet  *packet,
			guchar      *header,
			guchar      *data);

void    nd_tcp_urp_cb(LND_Packet  *packet,
		      guchar      *header,
		      guchar      *data);

/* Option field callbacks */



/* TCP menu callbacks */

void    nd_tcp_cksum_fix_cb(LND_Packet  *packet,
			    guchar      *header,
			    int          value);

#endif
