/*

Copyright (C) 2000 - 2010 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include <nd_dialog.h>
#include "nd_bpf.h"

void
bpf_on_ok_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  LND_Filter *filter;
  GtkWidget *dialog, *entry;
  LND_BPF_Params bpf_params;

  dialog = gtk_widget_get_toplevel(GTK_WIDGET(button));

  ND_GTK_GET(entry, dialog, "bpf_name_entry");
  bpf_params.filter_name = gtk_entry_get_text(GTK_ENTRY(entry));
  
  ND_GTK_GET(entry, dialog, "bpf_expr_entry");
  bpf_params.filter_expr = gtk_entry_get_text(GTK_ENTRY(entry));

  if ( (filter = libnd_bpf_new(&bpf_params)))
    {
      libnd_filter_set_factory(filter, nd_bpf_get_factory());
      libnd_filter_registry_add(filter);
      gtk_widget_hide(dialog);
    }

  return;
  TOUCH(user_data);
}


void
bpf_on_cancel_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_hide(gtk_widget_get_toplevel(GTK_WIDGET(button)));

  return;
  TOUCH(user_data);
}

