/***************************** LICENSE START ***********************************

 Copyright 2018 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MVQSTYLEHELP_H
#define MVQSTYLEHELP_H


#include "MvQRequestPanelHelp.h"
#include "Parameter.h"

#include <QPen>
#include <QWidget>
#include <QAbstractItemModel>
#include <QStyledItemDelegate>

class QComboBox;
class QLabel;
class QLineEdit;
class QPushButton;
class QSlider;
class QSpinBox;
class QTabWidget;
class QToolButton;
class QTreeView;
class QSortFilterProxyModel;

class MvQStyleDbItem;
class  RequestPanel;

class MvQStyleDelegate : public QStyledItemDelegate
{
public:
    MvQStyleDelegate(QWidget *parent=0);
    void paint(QPainter *painter,const QStyleOptionViewItem &option,
                   const QModelIndex& index) const;
    QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const;

protected:
    QColor borderCol_;
};

//Model to dislay/select the suites
class MvQStyleModel : public QAbstractItemModel
{
public:
    enum CustomItemRole {SortRole=Qt::UserRole+1};

    explicit MvQStyleModel(QObject *parent=0);
    ~MvQStyleModel();

    int columnCount (const QModelIndex& parent = QModelIndex() ) const;
    int rowCount (const QModelIndex& parent = QModelIndex() ) const;

    QVariant data (const QModelIndex& , int role = Qt::DisplayRole ) const;
    QVariant headerData(int,Qt::Orientation,int role = Qt::DisplayRole ) const;

    QModelIndex index (int, int, const QModelIndex& parent = QModelIndex() ) const;
    QModelIndex parent (const QModelIndex & ) const;

    void setKeywordFilter(QString s);
    void setColourFilter(QString s);
    void setLayerFilter(QString s);
    void setNameFilter(QString s);
    void clearFilter();

protected:
    bool isFiltered(MvQStyleDbItem *item) const;

    QString nameFilter_;
    QString keywordFilter_;
    QString colourFilter_;
    QString layerFilter_;
};

class MvQStyleSelectionWidget : public QWidget
{
    Q_OBJECT
public:
    MvQStyleSelectionWidget(QWidget* parent=0);
    void setCurrent(const std::string&);

protected slots:
    void slotKeywordFilter(int);
    void slotColourFilter(int);
    void slotLayerFilter(int);
    void slotNameFilter(QString s);
    void slotResetKeywordFilter();
    void slotResetColourFilter();
    void slotResetLayerFilter();
    void slotItemSelected(const QModelIndex&);
    void slotClearFilter();

signals:
    void itemSelected(int);

protected:
    void checkButtonState();

    bool ignoreFilterChanged_;
    QToolButton* resetTb_;

    QLineEdit *nameLe_;
    QComboBox* keywordCb_;
    QComboBox* colourCb_;
    QComboBox* layerCb_;

    QToolButton *nameResetTb_;
    QToolButton *keywordResetTb_;
    QToolButton *colourResetTb_;
    QToolButton *layerResetTb_;

    QTreeView *tree_;
    MvQStyleModel* model_;
    QSortFilterProxyModel *sortModel_;
};

class MvQStyleHelp : public MvQRequestPanelHelp
{
Q_OBJECT

public:
    MvQStyleHelp(RequestPanel& owner,const Parameter& param);
    ~MvQStyleHelp() {}

    void start() {}
    bool dialog() {return false;}
    QWidget* widget() {return selector_;}

public slots:
    void slotSelected(int);

protected:
    virtual void refresh(const vector<string>&);

private:
    MvQStyleSelectionWidget* selector_;
    QString oriName_;
};

#endif // MVQSTYLEHELP_H

