/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

//
// .NAME:	
//  XSectView
//
// .AUTHOR:
//  Gilberto Camara and Fernando Ii
//
// .SUMMARY:
//  Describes the XSectView class, which handles the
//  matching issues related to the XSect View
//
//
// .CLIENTS:
//  DropAction
//
// .RESPONSIBILITY:
//
////  - When receiving a drop or a request in a page associated
//    to a service view, call the service to process the request
//
//  - When the application is finished, pass the request sent
//    by the application to the presentable, which then should 
//    perform the data matching
//
//  
// .COLLABORATORS:
//  MvRequest - extracts information from the request
//  MvTask - communication with METVIEW modules
//
// .DESCENDENT:
//
// .RELATED:
//  Presentable, SuperPage, Page, DataObject
//
// .ASCENDENT:
// ServiceView
//

#ifndef XSectView_H
#define XSectView_H

#include "CommonXSectView.h"

//---------------------------------------------------------------------
// XSection factory definition
class XSectViewFactory : public PlotModViewFactory {

   // --  Virtual Constructor - Builds a new XSectView
   virtual PlotModView* Build ( Page&, const MvRequest&, const MvRequest& );

public:

   // Constructors
   XSectViewFactory() : PlotModViewFactory ( "XSectionView" ) {}
};

//---------------------------------------------------------------------
// XSection factory definition to handle translation from Metview 3 to 4.
// This should be delete in the future. It is defined here for backwards
// compatibility.
class XSectViewM3Factory : public PlotModViewFactory
{
   // --  Virtual Constructor - Builds a new XSectView
   virtual PlotModView* Build ( Page&, const MvRequest&, const MvRequest& );

   // Translate Metview 3 view request to Metview 4
   MvRequest Translate ( const MvRequest& );

public:

   // Constructors
   XSectViewM3Factory() : PlotModViewFactory ( "XSectM3View" ) {}
};

//---------------------------------------------------------------------
// XSection class definition
class XSectView: public CommonXSectView {

public:

    // -- Constructors
    XSectView( Page&, const MvRequest&, const MvRequest& );
    XSectView(const XSectView&);
    virtual PlotModView *Clone() const { return new XSectView(*this); }

    // -- Destructor
    ~XSectView() {} 

    // -- Methods
    // -- Overriden from CommonXSectView class
    virtual string Name();

    // Draw the background (axis )
    virtual void DrawBackground ( ) {}

    // Describe the contents of the view
    virtual void DescribeYourself ( ObjectInfo& );

    // Initialize some variable members
    virtual void SetVariables(const MvRequest&, bool);

    // Update view
    virtual bool UpdateView ();

    // Check consistency between the View and Data Module
    virtual bool ConsistencyCheck( MvRequest&, MvRequest& );


private:

    // Save some data specific to some DataApplication
    virtual void ApplicationInfo( const MvRequest& );

    // No assignment
    XSectView& operator=(const XSectView&);

    // Variables members
    string yReverse_;  // Y axis direction: "on"/"off"
};
#endif
