/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef EditorFactory_H
#include "EditorFactory.h"
#endif

#ifndef IconObject_H
#include "IconObject.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#ifndef IconClass_H
#include "IconClass.h"
#endif

#ifndef Editor_H
#include "Editor.h"
#endif

#ifndef ReplyObserver_H
#include "ReplyObserver.h"
#endif

#ifndef QtMacroEditor_H
#include "QtMacroEditor.h"
#endif


QtMacroEditor::QtMacroEditor(const IconClass& name,const string& kind):
    Editor(name,kind)
{
}

QtMacroEditor::~QtMacroEditor()
{
}



// -----------------------------------------------------------------
// QtMacroEditor::edit
// Called to start editing a macro. We call the macroedit service to
// bring up the Qt macro editor.

void QtMacroEditor::edit(void)
{
    string path = current_->path().str();

    replyObserver_ = new MacroEditorObserver(*this, path);
    replyObserver_->start();


//    replyObserver_->callService("macroedit", r);


//    task_->start();


}




//=================================================================

MacroEditorObserver::MacroEditorObserver(QtMacroEditor &editor, string &path) :
    editor_(editor), path_(path)
{
}

MacroEditorObserver::~MacroEditorObserver()
{
}


void MacroEditorObserver::start()
{
    // Editor::edit will already have set up the path that we need

    MvRequest r("MACROEDIT");

    r("PATH")     = path_.c_str();  // path to macro
    r("LANGUAGE") = editor_.iconClass().name().c_str(); // icon class, e.g. MACRO or MAGML
    r("_CLASS")   = editor_.iconClass().name().c_str(); // icon class, e.g. MACRO or MAGML
    callService("macroedit", r);
//    MvApplication::callService("macroedit", r, NULL);

}



void MacroEditorObserver::reply(const Request& r,int err)
{

    editor_.notifyObserverApply();
    editor_.Editor::done();

}

void MacroEditorObserver::progress(const Request& r)
{
}

void MacroEditorObserver::message(const string& msg)
{
}


void MacroEditorObserver::print(ostream& s) const
{
}





static EditorMaker<QtMacroEditor> editorMaker("QtMacroEditor");

