/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File RGBMaker.h
// Baudouin Raoult - ECMWF Oct 99

#ifndef RGBMaker_H
#define RGBMaker_H

#ifndef Rainbow_H
#include "Rainbow.h"
#endif

#include <Palette.h>

//------------------------------------------------------------------

template<class T>
class RGBMaker : public RainbowMaker {

	const RGBColor& c_;
	
public:

	RGBMaker(const RGBColor& c) : c_(c) {}

	virtual Pixel pixel(double x,double y) const
		{ 
			RGBColor c(T::R(x,y,c_),T::G(x,y,c_),T::B(x,y,c_));
			return XPalette::pixel(c);
		}
};

//------------------------------------------------------------------

struct makeRGB {
	static double R(double,double,const RGBColor& c) { return c.red;   }
	static double G(double,double,const RGBColor& c) { return c.green; }
	static double B(double,double,const RGBColor& c) { return c.blue;  }
};

struct makeR : public makeRGB {
	static double R(double x,double,const RGBColor&) { return x; }
};

struct makeG : public makeRGB {
	static double G(double x,double,const RGBColor&) { return x; }
};

struct makeB : public makeRGB {
	static double B(double x,double,const RGBColor&) { return x; }
};

//------------------------------------------------------------------

#endif
