/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ODBEditor_H
#include "ODBEditor.h"
#endif

#ifndef EditorFactory_H
#include "EditorFactory.h"
#endif

#ifndef XMList_H
#include "XMList.h"
#endif

#ifndef XMText_H
#include "XMText.h"
#endif



ODBEditor::ODBEditor(const IconClass& name,const string& kind):
	XEditor<UIODBEditor_c>(name,kind)
{
}

ODBEditor::~ODBEditor()
{
}

void ODBEditor::apply()
{
}

void ODBEditor::reset()
{
	parseDDfile();

	XMList p(constants_);
	p.clear();
	for(map<string,string>::iterator j = params_.begin(); j != params_.end(); ++j)
		p.add((*j).first);

	XMList t(tablesList_);
	t.clear();
	for(map<string,map<string,vector<string> > >::iterator k = tables_.begin(); k != tables_.end(); ++k)
		t.add((*k).first,true);

	XMList(columnsList_).clear();
	XMList(fieldsList_).clear();
	XMList(selectList_).clear();

	adjustButtons();
}

void ODBEditor::close()
{
}

void ODBEditor::merge(IconObject* o)
{
}

void ODBEditor::replace(IconObject* o)
{
}

string ODBEditor::alternateEditor()
{
  return "SimpleEditor";
}

map<string,string>& ODBEditor::params()
{
	return params_;
}

void ODBEditor::parseDDfile()
{
	params_.clear();
	tables_.clear();

	char cmd[10240];
	sprintf(cmd,"$METVIEW_BIN/odb_lang.pl /scratch/ma/mab/a/CCMA/CCMA.dd");
	FILE* f = popen(cmd,"r");
	if(f)
	{
		while(fgets(cmd,sizeof(cmd),f))
		{
			if(cmd[0] == '$')
			{
				char n[80];
				char v[80];
				sscanf(cmd,"%s %s",n,v);
				params_[n] = v;
			}

			if(cmd[0] == '+')
			{
				char t[80];
				char c[80];
				char f[80];

				t[0] = c[0] = f[0] = 0;
				sscanf(&cmd[2],"%s %s %s",t,c,f);

				vector<string>& v = tables_[t][c];
				if(f[0]) v.push_back(f);
			}
		}
		pclose(f);
	}

}

void ODBEditor::browseTablesCB(Widget,XtPointer)
{
	XMList t(tablesList_); XMList c(columnsList_);
	vector<string> s = t.selection();
	cout << s[0] << endl;

	c.clear();
	map<string,vector<string> >& x = tables_[s[0]];
	for(map<string,vector<string> > ::iterator k = x.begin(); k != x.end(); ++k)
		c.add((*k).first,(*k).second.size() > 0);

	XMList(fieldsList_).clear();

	adjustButtons();

}

void ODBEditor::browseColumnsCB(Widget,XtPointer)
{
	XMList t(tablesList_); 
	XMList c(columnsList_);

	vector<string> s = t.selection();
	vector<string> u = c.selection();

	XMList f(fieldsList_);

	f.clear();
	vector<string>& x = tables_[s[0]][u[0]];

	for(vector<string>::iterator k = x.begin(); k != x.end(); ++k)
		f.add(*k);

	adjustButtons();
}

void ODBEditor::sql(Widget w)
{
	sql_ = w;
}

void ODBEditor::constants(Widget w)
{
	constants_ = w;
}

void ODBEditor::browseFieldsCB(Widget,XtPointer)
{
	adjustButtons();
}

void ODBEditor::browseSelectCB(Widget,XtPointer)
{
	adjustButtons();
}

void ODBEditor::addCB(Widget,XtPointer)
{
	string x = selectedVariable();
	if(x != "")
		XMList(selectList_).add(x);
	adjustButtons();
}

string ODBEditor::selectedVariable()
{
	XMList t(tablesList_); 
	XMList c(columnsList_);
	XMList f(fieldsList_);

	vector<string> s = t.selection();
	vector<string> u = c.selection();
	vector<string> v = f.selection();

	if(!s.size()) return "";
	if(!u.size()) return "";

	if(tables_[s[0]][u[0]].size())
		if(!v.size())
			return "";

	string x = u[0];
	if(v.size()) 
		x = x + "." + v[0];

	x = x + "@" + s[0];

	return x;

}

void ODBEditor::removeCB(Widget,XtPointer)
{
	XMList l(selectList_);
	l.remove(l.selection());
	adjustButtons();
}

void ODBEditor::adjustButtons()
{
	XMList l(selectList_);

	string x = selectedVariable();
	XtSetSensitive(add_,(x != "") && !l.exists(x));

	XtSetSensitive(insert_,(x != ""));

	vector<string> s = l.selection();
	XtSetSensitive(remove_,s.size()>0); 

	vector<string> v = l.values();

	XtSetSensitive(up_,s.size()>0 && v[0] != s[0]); 
	XtSetSensitive(down_,s.size()>0 && v[v.size()-1] != s[0]); 

	s = l.values();
	XMText t(sql_);
	x = "SELECT ";

	for(vector<string>::iterator k = s.begin(); k != s.end(); ++k)
	{
		if(k != s.begin())
			x += ",\n       ";
		x += (*k);
	}

	x += "\nFROM *";


	XMText w(whereText_);
	x += "\nWHERE ";
	x += w.get();

	t.set(x);
}

void ODBEditor::insert(const string& s)
{
	XMText(whereText_).insert(s);
	adjustButtons();
}

void ODBEditor::upCB(Widget,XtPointer)
{
	XMList l(selectList_);

	vector<string> s = l.selection();
	vector<string> v = l.values();

	int j = 0;
	for(int i = 0; i < v.size(); i++)
		if(v[i] == s[0])
			j = i;

	string t = v[j]; v[j] = v[j-1]; v[j-1] = t;
	l.clear();
	l.add(v);
	l.select(s[0]);

	adjustButtons();
}

void ODBEditor::downCB(Widget,XtPointer)
{
	XMList l(selectList_);

	vector<string> s = l.selection();
	vector<string> v = l.values();

	int j = 0;
	for(int i = 0; i < v.size(); i++)
		if(v[i] == s[0])
			j = i;

	string t = v[j]; v[j] = v[j+1]; v[j+1] = t;
	l.clear();
	l.add(v);
	l.select(s[0]);

	adjustButtons();
}

void ODBEditor::insertCB(Widget,XtPointer)
{
	insert(selectedVariable());
}

void ODBEditor::doubleClickCB(Widget,XtPointer)
{
	string x = selectedVariable();
	if(x != "")
		insert(x);
}

void ODBEditor::changedCB(Widget,XtPointer)     
{
	adjustButtons();  
}

static EditorMaker<ODBEditor> editorMaker("ODBEditor");
