/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File Basic.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef Basic_H
#define Basic_H

#ifndef IconObject_H
#include "IconObject.h"
#endif

#include <string>
using std::string;


class Basic : public IconObject {
public:

// -- Exceptions
	// None

// -- Contructors

	Basic(Folder* parent,
		const IconClass& kind, const string& name,
		IconInfo* info);

// -- Destructor

	virtual ~Basic(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods


// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods

	// From IconObject
	virtual Request request() const;
	virtual const set<DependancyH>& dependancies();
	virtual Request fullRequest() const;

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	Basic(const Basic&);
	Basic& operator=(const Basic&);

// -- Members

// -- Methods
	// None

// -- Overridden methods

	// From IconObject

	virtual void doubleClick();
	virtual set<string> can();

	virtual void createFiles();
	virtual void    request(const Request&);
	virtual bool rename(const string&);
	virtual IconObject* clone(Folder*);


// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const Basic& p)
	//	{ p.print(s); return s; }

};

inline void destroy(Basic**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(Basic);
//#endif

#endif
