/**
 * @file:   MultiExtensionTypes.h
 * @brief:  Implementation of the MultiExtensionTypes class
 * @author: SBMLTeam
 *
 * <!--------------------------------------------------------------------------
 * This file is part of libSBML.  Please visit http://sbml.org for more
 * information about SBML, and the latest version of libSBML.
 *
 * Copyright (C) 2013-2018 jointly by the following organizations:
 *     1. California Institute of Technology, Pasadena, CA, USA
 *     2. EMBL European Bioinformatics Institute (EMBL-EBI), Hinxton, UK
 *     3. University of Heidelberg, Heidelberg, Germany
 *
 * Copyright (C) 2009-2013 jointly by the following organizations:
 *     1. California Institute of Technology, Pasadena, CA, USA
 *     2. EMBL European Bioinformatics Institute (EMBL-EBI), Hinxton, UK
 *
 * Copyright (C) 2006-2008 by the California Institute of Technology,
 *     Pasadena, CA, USA 
 *
 * Copyright (C) 2002-2005 jointly by the following organizations:
 *     1. California Institute of Technology, Pasadena, CA, USA
 *     2. Japan Science and Technology Agency, Japan
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.  A copy of the license agreement is provided
 * in the file named "LICENSE.txt" included with this software distribution
 * and also available online as http://sbml.org/software/libsbml/license.html
 * ------------------------------------------------------------------------ -->
 */
#ifndef MultiExtensionTypes_H
#define MultiExtensionTypes_H

#include <sbml/packages/multi/common/multifwd.h>

#include <sbml/packages/multi/extension/MultiASTPlugin.h>
#include <sbml/packages/multi/extension/MultiCompartmentPlugin.h>
#include <sbml/packages/multi/extension/MultiExtension.h>
#include <sbml/packages/multi/extension/MultiListOfReactionsPlugin.h>
#include <sbml/packages/multi/extension/MultiModelPlugin.h>
#include <sbml/packages/multi/extension/MultiSBMLDocumentPlugin.h>
#include <sbml/packages/multi/extension/MultiSimpleSpeciesReferencePlugin.h>
#include <sbml/packages/multi/extension/MultiSpeciesPlugin.h>
#include <sbml/packages/multi/extension/MultiSpeciesReferencePlugin.h>

#include <sbml/packages/multi/sbml/BindingSiteSpeciesType.h>
#include <sbml/packages/multi/sbml/CompartmentReference.h>
#include <sbml/packages/multi/sbml/InSpeciesTypeBond.h>
#include <sbml/packages/multi/sbml/IntraSpeciesReaction.h>
#include <sbml/packages/multi/sbml/MultiSpeciesType.h>
#include <sbml/packages/multi/sbml/OutwardBindingSite.h>
#include <sbml/packages/multi/sbml/PossibleSpeciesFeatureValue.h>
#include <sbml/packages/multi/sbml/SpeciesFeature.h>
#include <sbml/packages/multi/sbml/SubListOfSpeciesFeatures.h>
#include <sbml/packages/multi/sbml/SpeciesFeatureType.h>
#include <sbml/packages/multi/sbml/SpeciesFeatureValue.h>
#include <sbml/packages/multi/sbml/SpeciesTypeComponentIndex.h>
#include <sbml/packages/multi/sbml/SpeciesTypeComponentMapInProduct.h>
#include <sbml/packages/multi/sbml/SpeciesTypeInstance.h>


#endif  /* MultiExtensionTypes_H */
