using System;
using System.Runtime.InteropServices;
 
//------------------------------------------------------------------------------
// <auto-generated />
//
// This file was automatically generated by SWIG (http://www.swig.org).
// Version 3.0.12
//
// Do not make changes to this file unless you know what you are doing--modify
// the SWIG interface file instead.
//------------------------------------------------------------------------------

namespace libsbmlcs {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html A discontinuous SBML <em>event</em>.
 * 
 * An SBML Event object defines when the event can occur, the variables
 * that are affected by it, how the variables are affected, and the event's
 * relationship to other events.  The effect of the event can optionally be
 * delayed after the occurrence of the condition which invokes it.
 *
 * The operation of Event is divided into two phases (even when the event
 * is not delayed): one when the event is @em triggered, and the other when
 * the event is @em executed.  Trigger objects define the conditions for
 * triggering an event, Delay objects define when the event is actually
 * executed, EventAssignment objects define the effects of executing the
 * event, and (in SBML Level&nbsp;3) Priority objects influence the order
 * of EventAssignment performance in cases of simultaneous events.  Please
 * consult the descriptions of Trigger, Delay, EventAssignment and Priority
 * for more information.
 *
 * @section event-version-diffs SBML Level/Version differences
 * 
 * @subsection sbml-l2 SBML Level 2
 * 
 * In SBML Level&nbsp;2 versions before Version&nbsp;4, the semantics of
 * Event time delays were defined such that the expressions in the event's
 * assignments were always evaluated at the time the event was
 * <em>triggered</em>.  This definition made it difficult to define an event
 * whose assignment formulas were meant to be evaluated at the time the
 * event was <em>executed</em> (i.e., after the time period defined
 * by the value of the Delay element, or after any other simultaneous
 * event may have been <em>executed</em> and changed the model state).
 * In SBML Level&nbsp;2 Version&nbsp;4 and in
 * Level&nbsp;3, the attribute 'useValuesFromTriggerTime' on Event was added 
 * to allow a model to indicate the time at which the event's assignments 
 * are to be calculated, whether at the moment the event is triggered (if
 * the value of the attribute is @c true), or at the moment of execution
 * (if 'useValuesFromTriggerTime'=@c false).  If the event has a delay,
 * the 'useValuesFromTriggerTime' is likely to make a significant difference
 * in the values used in the assignment, but the possibility of simultaneous
 * events mean that even zero-delay events can have different results
 * depending on the value of this attribute.
 *
 * The definition of Event in SBML Level&nbsp;2 Versions 1 and 2 includes
 * an additional attribute called 'timeUnits', which allowed the time units
 * of the Delay to be set explicitly.  Later Versions of SBML Level&nbsp;2
 * as well as SBML Level&nbsp;3 do not define this attribute.  LibSBML
 * supports this attribute for compatibility with previous versions of SBML
 * Level&nbsp;2; however, if a model in SBML Level&nbsp;3 or Level&nbsp;2
 * Versions&nbsp;3&ndash;4 format sets the attribute, the
 * consistency-checking method SBMLDocument::checkConsistency() will report
 * an error.
 *
 * The attribute 'useValuesFromTriggerTime' was introduced in SBML
 * Level&nbsp;2 Version&nbsp;4.  Models defined in prior Versions of SBML
 * Level&nbsp;2 cannot use this attribute, and
 * SBMLDocument::checkConsistency() will report an error if they do.
 *
 * @subsection sbml-l3 SBML Level 3
 *
 * SBML Level 3 introduces several changes to the structure and components
 * of Events compared to SBML Level&nbsp;2.  These changes fall into two
 * main categories: changes to what is optional or required, and additions
 * of new attributes and elements.
 * <ul>
 * <li> The attribute 'useValuesFromTriggerTime' on Event is mandatory (it
 * was optional in Level&nbsp;2 and had a default value of @c true);
 * <li> Event's 'listOfEventAssignments' element (of class
 * ListOfEventAssignments) is optional (it was mandatory in Level&nbsp;2);
 * <li> Event's 'priority' element (of class Priority) is new in
 * Level&nbsp;3; and
 * <li> The Trigger object gains new mandatory attributes (described as part
 * of the definition of Trigger).
 * <li> In SBML Level&nbsp;3 Version&nbsp;2, the Trigger object became 
 * optional.  An Event with no Trigger will simply not fire.
 * </ul>
 *
 * The changes to the attributes of Event are described below; the changes
 * to Trigger and Priority are described in their respective sections.
 *
 * @section semantics Semantics of events in SBML Level&nbsp;3 Version&nbsp;1
 *
 * The detailed semantics of events are described in the specification
 * documents for each SBML Level/Version.  Here we include the description
 * from the SBML Level&nbsp;1 Version&nbsp;1.
 * Any transition of a Trigger object's 'math' formula from the value
 * @c false to @c true will cause the enclosing Event object to
 * <em>trigger</em>.  Such a transition is not possible at the very start
 * of a simulation (i.e., at time <em>t = 0</em>) unless the Trigger
 * object's 'initialValue' attribute has a value of @c false; this defines
 * the value of the trigger formula to be @c false immediately prior to the
 * start of simulation, thereby giving it the potential to change in value
 * from @c false to @c true when the formula is evaluated at <em>t =
 * 0</em>.  If 'initialValue'=@c true, then the trigger expression cannot
 * transition from @c false to @c true at <em>t = 0</em> but may do so at
 * some time <em>t > 0</em>.
 * 
 * Consider an Event object definition <EM>E</EM> with delay <em>d</em> in
 * which the Trigger object's 'math' formula makes a transition in value
 * from @c false to @c true at times <em>t<sub>1</sub></em> and
 * <em>t<sub>2</sub></em>.  The EventAssignment within the Event object
 * will have effect at <em>t<sub>1</sub> + d</em> and
 * <em>t<sub>2</sub> + d</em> irrespective of the relative times of
 * <em>t<sub>1</sub></em> and <em>t<sub>2</sub></em>.  For example, events
 * can 'overlap' so that <em>t<sub>1</sub> < t<sub>2</sub> <
 * t<sub>1</sub> + d</em> still causes an event assignments to occur at
 * <em>t<sub>1</sub> + d</em> and <em>t<sub>2</sub> + d</em>.
 * 
 * It is entirely possible for two events to be executed simultaneously,
 * and it is possible for events to trigger other events (i.e., an event
 * assignment can cause an event to trigger).  This leads to several
 * points:
 * <ul>
 * 
 * <li> A software package should retest all event triggers after executing
 * an event assignment in order to account for the possibility that the
 * assignment causes another event trigger to transition from @c false to
 * @c true.  This check should be made after each individual Event object's
 * execution, even when several events are to be executed simultaneously.
 * 
 * <li> Any Event object whose Trigger 'persistent' attribute has the value
 * @c false must have its trigger expression reevaluated continuously
 * between when the event is triggered and when it is executed.  If
 * its trigger expression ever evaluates to @c false, it must be removed
 * from the queue of events pending execution and treated as any other
 * event whose trigger expression evaluates to @c false.
 * 
 * <li> Although the precise time at which events are executed is not
 * resolved beyond the given execution point in simulated time, it is
 * assumed that the order in which the events occur <em>is</em> resolved.
 * This order can be significant in determining the overall outcome of a
 * given simulation.  When an event <EM>X</EM> <em>triggers</em> another
 * event <EM>Y</EM> and event <EM>Y</EM> has zero delay, then event
 * <EM>Y</EM> is added to the existing set of simultaneous events that are
 * pending <em>execution</em>.  Events <EM>X</EM> and <EM>Y</EM> form a
 * cascade of events at the same point in simulation time.  An event such
 * as <EM>Y</EM> may have a special priority if it contains a Priority
 * subobject.
 * 
 * <li> All events in a model are open to being in a cascade.  The position
 * of an event in the event queue does not affect whether it can be in the
 * cascade: event <EM>Y</EM> can be triggered whether it is before or after
 * <EM>X</EM> in the queue of events pending execution.  A cascade of
 * events can be potentially infinite (never terminate); when this occurs a
 * simulator should indicate this has occurred---it is incorrect for a
 * simulator to break a cascade arbitrarily and continue the simulation
 * without at least indicating that the infinite cascade occurred.
 * 
 * <li> Simultaneous events having no defined priorities are executed in an
 * undefined order.  This does not mean that the behavior of the simulation
 * is completely undefined; merely that the <em>order</em> of execution of
 * these particular events is undefined.  A given simulator may use any
 * algorithm to choose an order as long as every event is executed exactly
 * once.
 * 
 * <li> Events with defined priorities are executed in the order implied by
 * their Priority 'math' formula values, with events having higher
 * priorities being executed ahead of events with lower priorities, and
 * events with identical priorities being executed in a random order with
 * respect to one another (as determined at run-time by some random
 * algorithm equivalent to coin-flipping).  Newly-triggered events that are
 * to be executed immediately (i.e., if they define no delays) should be
 * inserted into the queue of events pending execution according to their
 * priorities: events with higher priority values value must be inserted
 * ahead of events with lower priority values and after any pending events
 * with even higher priorities, and inserted randomly among pending events
 * with the same priority values.  Events without Priority objects must be
 * inserted into the queue in some fashion, but the algorithm used to place
 * it in the queue is undefined.  Similarly, there is no restriction on the
 * order of a newly-inserted event with a defined Priority with respect to
 * any other pending Event without a defined Priority.
 * 
 * <li> A model variable that is the target of one or more event
 * assignments can change more than once when simultaneous events are
 * processed at some time point <em>t</em>.  The model's behavior (output)
 * for such a variable is the value of the variable at the end of
 * processing all the simultaneous events at time <em>t</em>.
 * 
 * </ul>
 *
 * @section l3v2_restrictions Restrictions relaxed in SBML Level&nbsp;3 Version&nbsp;2
 *
 * In SBML Level&nbsp;3 Version&nbsp;2, several restrictions were lifted 
 * that have the potential to affect the semantics of an Event:
 *
 * <ul>
 * <li> The Trigger subobject of an Event is optional.  If missing,
 * an Event is never @em triggered, unless an alternate triggering 
 * scheme is introduced by an SBML Level&nbsp;3 package.
 *
 * <li> The 'math' subelements of an Event Trigger, Delay, Priority,
 * and EventAssignment are all optional.  If any of these elements lack 
 * a 'math' subelement, and that information is not supplied in an SBML
 * Level&nbsp;3 package, it is mathematically equivalent to the Trigger, 
 * Delay, Priority, or EventAssignment not being present at all.
 *
 * <li> The ListOfEventAssignments may be empty, which is mathematically 
 * equivalent to the Event not having a ListOfEventAssignments at all.
 *
 * <li> Any 'math' subelement may return a Boolean or a numeric value
 * in any context.  If a numeric value is used in a Boolean context,
 * a '0' is interpreted as @c false, and all other values are
 * interpreted as @c true.  If a Boolean value is used in a numeric 
 * context, a @c true is interpreted as a 1, and a @c false is 
 * interpreted as a 0.  This means (for example) that a Trigger value 
 * that changes from 0.0 to anything else is equivalent to changing 
 * from @c false to @c true.
 * </ul>
 *
 * @see Trigger
 * @see Priority
 * @see Delay
 * @see EventAssignment
 * 
 *
 * 
 */

public class Event : SBase {
	private HandleRef swigCPtr;
	
	internal Event(IntPtr cPtr, bool cMemoryOwn) : base(libsbmlPINVOKE.Event_SWIGUpcast(cPtr), cMemoryOwn)
	{
		//super(libsbmlPINVOKE.EventUpcast(cPtr), cMemoryOwn);
		swigCPtr = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(Event obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (Event obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~Event() {
    Dispose();
  }

  public override void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != global::System.IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_Event(swigCPtr);
        }
        swigCPtr = new global::System.Runtime.InteropServices.HandleRef(null, global::System.IntPtr.Zero);
      }
      global::System.GC.SuppressFinalize(this);
      base.Dispose();
    }
  }

  
/**
   * Creates a new Event using the given SBML @p level and @p version
   * values.
   *
   * @param level a long integer, the SBML Level to assign to this Event.
   *
   * @param version a long integer, the SBML Version to assign to this
   * Event.
   *
   *
 * @throws SBMLConstructorException
 * Thrown if the given @p level and @p version combination are invalid
 * or if this object is incompatible with the given level and version.
 *
 *
   *
   *
 * @note Attempting to add an object to an SBMLDocument having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * SBMLDocument), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
 *
 *
   */ public
 Event(long level, long version) : this(libsbmlPINVOKE.new_Event__SWIG_0(level, version), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new Event using the given SBMLNamespaces object
   * @p sbmlns.
   *
   *
 * 
 * The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's SBMLNamespaces facilities is to create an
 * SBMLNamespaces object somewhere in a program once, then hand that object
 * as needed to object constructors that accept SBMLNamespaces as arguments.
 *
 * 
   * 
   * @param sbmlns an SBMLNamespaces object.
   *
   *
 * @throws SBMLConstructorException
 * Thrown if the given @p sbmlns is inconsistent or incompatible
 * with this object.
 *
 *
   *
   *
 * @note Attempting to add an object to an SBMLDocument having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * SBMLDocument), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
 *
 *
   */ public
 Event(SBMLNamespaces sbmlns) : this(libsbmlPINVOKE.new_Event__SWIG_1(SBMLNamespaces.getCPtr(sbmlns)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Copy constructor; creates a copy of this Event.
   *
   * @param orig the object to copy.
   */ public
 Event(Event orig) : this(libsbmlPINVOKE.new_Event__SWIG_2(Event.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates and returns a deep copy of this Event object.
   *
   * @return the (deep) copy of this Event object.
   */ public new
 Event clone() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Event_clone(swigCPtr);
    Event ret = (cPtr == global::System.IntPtr.Zero) ? null : new Event(cPtr, true);
    return ret;
  }

  
/**
   * Initializes the fields of this Event object to 'typical' default
   * values.
   *
   * The SBML Event component has slightly different aspects and
   * default attribute values in different SBML Levels and Versions.
   * This method sets the values to certain common defaults, based
   * mostly on what they are in SBML Level&nbsp;2.  Specifically:
   *
   * @li Sets attribute 'useValuesFromTriggerTime' to @c true
   */ public
 void initDefaults() {
    libsbmlPINVOKE.Event_initDefaults(swigCPtr);
  }

  
/**
   * Returns the first child element found that has the given @p id in the
   * model-wide SId namespace, or @c null if no such object is found.
   *
   * @param id string representing the id of the object to find.
   *
   * @return pointer to the first element found with the given @p id.
   */ public new
 SBase getElementBySId(string id) {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.Event_getElementBySId(swigCPtr, id), false);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
	return ret;
}

  
/**
   * Returns the first child element it can find with the given @p metaid, or
   * @c null if no such object is found.
   *
   * @param metaid string representing the metaid of the object to find.
   *
   * @return pointer to the first element found with the given @p metaid.
   */ public new
 SBase getElementByMetaId(string metaid) {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.Event_getElementByMetaId(swigCPtr, metaid), false);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
	return ret;
}

  
/**
   * Returns the value of the 'id' attribute of this Event.
   *
   * @note Because of the inconsistent behavior of this function with 
   * respect to assignments and rules, it is now recommended to
   * use the getIdAttribute() function instead.
   *
   *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 *
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The exception to this rule is that for InitialAssignment, EventAssignment, 
 * AssignmentRule, and RateRule objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The AlgebraicRule fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return @c false.
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(@if java String@endif), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 * 
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 *
 *
   *
   * @return the id of this Event.
   *
   * @see getIdAttribute()
   * @see setIdAttribute(string sid)
   * @see isSetIdAttribute()
   * @see unsetIdAttribute()
   */ public new
 string getId() {
    string ret = libsbmlPINVOKE.Event_getId(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'name' attribute of this Event.
   *
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 *
 * @return the name of this SBML object, or the empty string if not set or unsettable.
 *
 * @see getIdAttribute()
 * @see isSetName()
 * @see setName(string sid)
 * @see unsetName()
 * 
 *
   */ public new
 string getName() {
    string ret = libsbmlPINVOKE.Event_getName(swigCPtr);
    return ret;
  }

  
/**
   * Get the event trigger portion of this Event.
   * 
   * @return the Trigger object of this Event, or @c null if the trigger is not set.
   */ public
 Trigger getTrigger() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Event_getTrigger__SWIG_0(swigCPtr);
    Trigger ret = (cPtr == global::System.IntPtr.Zero) ? null : new Trigger(cPtr, false);
    return ret;
  }

  
/**
   * Get the assignment delay portion of this Event, if there is one.
   * 
   * @return the delay of this Event if one is defined, or @c null if none
   * is defined.
   */ public
 Delay getDelay() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Event_getDelay__SWIG_0(swigCPtr);
    Delay ret = (cPtr == global::System.IntPtr.Zero) ? null : new Delay(cPtr, false);
    return ret;
  }

  
/**
   * (SBML Level&nbsp;3 only) Get the event priority portion of this
   * Event.
   * 
   * @return the Priority object of this Event, or @c null if the Priority
   * has not been set.
   * 
   * @note The element 'priority' is available in SBML Level&nbsp;3,
   * but is not present in lower Levels of SBML.
   */ public
 Priority getPriority() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Event_getPriority__SWIG_0(swigCPtr);
    Priority ret = (cPtr == global::System.IntPtr.Zero) ? null : new Priority(cPtr, false);
    return ret;
  }

  
/**
   * Get the value of the 'timeUnits' attribute of this Event, if it has one.
   * 
   * @return the value of the attribute 'timeUnits' as a string.
   *
   *
 * @warning <span class='warning'>Definitions of Event in SBML Level 2
 * Versions&nbsp;1 and&nbsp;2 included the additional attribute called
 * 'timeUnits', but it was removed in SBML Level&nbsp;2 Version&nbsp;3.
 * LibSBML supports this attribute for compatibility with previous versions
 * of SBML Level&nbsp;2, but its use is discouraged since models in
 * Level&nbsp;2 Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a
 * Version&nbsp;3 or&nbsp;4 model sets the attribute, the
 * consistency-checking method SBMLDocument::checkConsistency() will report
 * an error.</span>
 *
   */ public
 string getTimeUnits() {
    string ret = libsbmlPINVOKE.Event_getTimeUnits(swigCPtr);
    return ret;
  }

  
/**
   * Get the value of the 'useValuesFromTriggerTime' attribute of this Event.
   *
   *
 * 
 * The optional Delay on Event and the fact that multiple events may be
 * simultaneously executed means there are two times to consider when
 * computing the results of an event: the time at which the event is
 * <em>triggered</em>, and the time at which assignments are
 * <em>executed</em>.  It is also possible to distinguish between the
 * time at which the EventAssignment's expression is calculated, and the
 * time at which the assignment is made: the expression could be
 * evaluated at the same time the assignments are performed, i.e., when
 * the event is <em>executed</em>, but it could also be defined to be
 * evaluated at the time the event is <em>triggered</em>.
 * 
 * In SBML Level&nbsp;2 versions prior to Version&nbsp;4, the semantics
 * of Event time delays were defined such that the expressions in the
 * event's assignments were always evaluated at the time the event was
 * <em>triggered</em>.  This definition made it difficult to define an
 * event whose assignment formulas were meant to be evaluated at the time
 * the event was <em>executed</em> (i.e., after the time period defined
 * by the value of the Delay element, or after any other simultaneous
 * event may have been <em>executed</em> and changed the model state).
 * In SBML Level&nbsp;2
 * Version&nbsp;4, the attribute 'useValuesFromTriggerTime' on Event
 * allows a model to indicate the time at which the event's assignments
 * are intended to be evaluated.  In SBML Level&nbsp;2, the attribute has
 * a default value of @c true, which corresponds to the interpretation of
 * event assignments prior to Version&nbsp;4: the values of the
 * assignment formulas are computed at the moment the event is triggered,
 * not after the delay.  If 'useValuesFromTriggerTime'=@c false, it means
 * that the formulas in the event's assignments are to be computed after
 * the delay, at the time the event is executed.  In SBML Level&nbsp;3,
 * the attribute is mandatory, not optional, and all events must specify
 * a value for it.
 *
   * 
   * @return the value of the attribute 'useValuesFromTriggerTime' as a boolean.
   *
   *
 * @warning <span class='warning'>The attribute 'useValuesFromTriggerTime'
 * was introduced in SBML Level&nbsp;2 Version&nbsp;4.  It is not valid in
 * models defined using SBML Level&nbsp;2 versions prior to Version&nbsp;4.
 * If a Level&nbsp;2 Version&nbsp;1&ndash;3 model sets the attribute, the
 * consistency-checking method SBMLDocument::checkConsistency() will report
 * an error.</span>
 * 
   */ public
 bool getUseValuesFromTriggerTime() {
    bool ret = libsbmlPINVOKE.Event_getUseValuesFromTriggerTime(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Event's 'id' attribute is set.
   *
   *
 *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 *
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The exception to this rule is that for InitialAssignment, EventAssignment, 
 * AssignmentRule, and RateRule objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The AlgebraicRule fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return @c false.
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(@if java String@endif), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 * 
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 *
 *
 *
 * @return @c true if the 'id' attribute of this SBML object is
 * set, @c false otherwise.
 *
 * @note Because of the inconsistent behavior of this function with
 * respect to assignments and rules, it is recommended that callers
 * use isSetIdAttribute() instead.
 *
 * @see getIdAttribute()
 * @see setIdAttribute(string sid)
 * @see unsetIdAttribute()
 * @see isSetIdAttribute()
 *
 *
   */ public new
 bool isSetId() {
    bool ret = libsbmlPINVOKE.Event_isSetId(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Event's 'name' attribute is set.
   *
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 * 
 * @return @c true if the 'name' attribute of this SBML object is
 * set, @c false otherwise.
 *
 * @see getName()
 * @see setName(string sid)
 * @see unsetName()
 *
 *
   */ public new
 bool isSetName() {
    bool ret = libsbmlPINVOKE.Event_isSetName(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether the trigger for this Event is set.
   *
   * @return @c true if the trigger of this Event is set, @c false
   * otherwise.
   */ public
 bool isSetTrigger() {
    bool ret = libsbmlPINVOKE.Event_isSetTrigger(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether the delay for this Event is set.
   *
   * @return @c true if the delay of this Event is set, @c false
   * otherwise.
   */ public
 bool isSetDelay() {
    bool ret = libsbmlPINVOKE.Event_isSetDelay(swigCPtr);
    return ret;
  }

  
/**
   * (SBML Level&nbsp;3 only) Predicate for testing whether the priority
   * for this Event is set.
   *
   * @return @c true if the priority of this Event is set, @c false
   * otherwise.
   * 
   * @note The element 'priority' is available in SBML Level&nbsp;3,
   * but is not present in lower Levels of SBML.
   */ public
 bool isSetPriority() {
    bool ret = libsbmlPINVOKE.Event_isSetPriority(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether the 'timeUnits' attribute of this Event
   * is set.
   *
   * @return @c true if the 'timeUnits' attribute of this Event is
   * set, @c false otherwise.
   *
   *
 * @warning <span class='warning'>Definitions of Event in SBML Level 2
 * Versions&nbsp;1 and&nbsp;2 included the additional attribute called
 * 'timeUnits', but it was removed in SBML Level&nbsp;2 Version&nbsp;3.
 * LibSBML supports this attribute for compatibility with previous versions
 * of SBML Level&nbsp;2, but its use is discouraged since models in
 * Level&nbsp;2 Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a
 * Version&nbsp;3 or&nbsp;4 model sets the attribute, the
 * consistency-checking method SBMLDocument::checkConsistency() will report
 * an error.</span>
 *
   */ public
 bool isSetTimeUnits() {
    bool ret = libsbmlPINVOKE.Event_isSetTimeUnits(swigCPtr);
    return ret;
  }

  
/**
   * Predicate for testing whether the 'useValuesFromTriggerTime' attribute of this Event
   * is set.
   *
   * @return @c true if the 'useValuesFromTriggerTime' attribute of this Event is
   * set, @c false otherwise.
   *
   * @note In SBML Level&nbsp;2, this attribute is optional and has a default value of
   * @c true, whereas in Level&nbsp;3, this optional is mandatory and
   * has no default value.
   */ public
 bool isSetUseValuesFromTriggerTime() {
    bool ret = libsbmlPINVOKE.Event_isSetUseValuesFromTriggerTime(swigCPtr);
    return ret;
  }

  
/**
   * Sets the value of the 'id' attribute of this Event.
   *
   *
 * 
 * The string @p sid is copied.
 *
 *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 *
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The exception to this rule is that for InitialAssignment, EventAssignment, 
 * AssignmentRule, and RateRule objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The AlgebraicRule fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return @c false.
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(@if java String@endif), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 * 
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 *
 *
 * 
 * @param sid the string to use as the identifier of this object.
 *
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
 * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
 *
 * @see getIdAttribute()
 * @see setIdAttribute(string sid)
 * @see isSetIdAttribute()
 * @see unsetIdAttribute()
 * 
 *
   */ public new
 int setId(string sid) {
    int ret = libsbmlPINVOKE.Event_setId(swigCPtr, sid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the value of the 'name' attribute of this Event.
   *
   *
   *
 * 
 *
 * The string in @p name is copied.
 *
 * @param name the new name for the SBML object.
 *
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
 *
 *
   */ public new
 int setName(string name) {
    int ret = libsbmlPINVOKE.Event_setName(swigCPtr, name);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the trigger definition of this Event to a copy of the given
   * Trigger object instance.
   *
   * @param trigger the Trigger object instance to use.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
   */ public
 int setTrigger(Trigger trigger) {
    int ret = libsbmlPINVOKE.Event_setTrigger(swigCPtr, Trigger.getCPtr(trigger));
    return ret;
  }

  
/**
   * Sets the delay definition of this Event to a copy of the given Delay
   * object instance.
   *
   * @param delay the Delay object instance to use.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
   */ public
 int setDelay(Delay delay) {
    int ret = libsbmlPINVOKE.Event_setDelay(swigCPtr, Delay.getCPtr(delay));
    return ret;
  }

  
/**
   * (SBML Level&nbsp;3 only) Sets the priority definition of this Event
   * to a copy of the given Priority object instance.
   *
   * @param priority the Priority object instance to use.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * 
   * @note The element 'priority' is available in SBML Level&nbsp;3,
   * but is not present in lower Levels of SBML.
   */ public
 int setPriority(Priority priority) {
    int ret = libsbmlPINVOKE.Event_setPriority(swigCPtr, Priority.getCPtr(priority));
    return ret;
  }

  
/**
   * Sets the 'timeUnits' attribute of this Event to a copy of @p sid.
   *
   * @param sid the identifier of the time units to use.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   *
 * @warning <span class='warning'>Definitions of Event in SBML Level 2
 * Versions&nbsp;1 and&nbsp;2 included the additional attribute called
 * 'timeUnits', but it was removed in SBML Level&nbsp;2 Version&nbsp;3.
 * LibSBML supports this attribute for compatibility with previous versions
 * of SBML Level&nbsp;2, but its use is discouraged since models in
 * Level&nbsp;2 Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a
 * Version&nbsp;3 or&nbsp;4 model sets the attribute, the
 * consistency-checking method SBMLDocument::checkConsistency() will report
 * an error.</span>
 *
   *
   */ public
 int setTimeUnits(string sid) {
    int ret = libsbmlPINVOKE.Event_setTimeUnits(swigCPtr, sid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the 'useValuesFromTriggerTime' attribute of this Event to a @p value.
   * 
   *
 * 
 * The optional Delay on Event and the fact that multiple events may be
 * simultaneously executed means there are two times to consider when
 * computing the results of an event: the time at which the event is
 * <em>triggered</em>, and the time at which assignments are
 * <em>executed</em>.  It is also possible to distinguish between the
 * time at which the EventAssignment's expression is calculated, and the
 * time at which the assignment is made: the expression could be
 * evaluated at the same time the assignments are performed, i.e., when
 * the event is <em>executed</em>, but it could also be defined to be
 * evaluated at the time the event is <em>triggered</em>.
 * 
 * In SBML Level&nbsp;2 versions prior to Version&nbsp;4, the semantics
 * of Event time delays were defined such that the expressions in the
 * event's assignments were always evaluated at the time the event was
 * <em>triggered</em>.  This definition made it difficult to define an
 * event whose assignment formulas were meant to be evaluated at the time
 * the event was <em>executed</em> (i.e., after the time period defined
 * by the value of the Delay element, or after any other simultaneous
 * event may have been <em>executed</em> and changed the model state).
 * In SBML Level&nbsp;2
 * Version&nbsp;4, the attribute 'useValuesFromTriggerTime' on Event
 * allows a model to indicate the time at which the event's assignments
 * are intended to be evaluated.  In SBML Level&nbsp;2, the attribute has
 * a default value of @c true, which corresponds to the interpretation of
 * event assignments prior to Version&nbsp;4: the values of the
 * assignment formulas are computed at the moment the event is triggered,
 * not after the delay.  If 'useValuesFromTriggerTime'=@c false, it means
 * that the formulas in the event's assignments are to be computed after
 * the delay, at the time the event is executed.  In SBML Level&nbsp;3,
 * the attribute is mandatory, not optional, and all events must specify
 * a value for it.
 *
   *
   * @param value the value of useValuesFromTriggerTime to use.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   *
 * @warning <span class='warning'>The attribute 'useValuesFromTriggerTime'
 * was introduced in SBML Level&nbsp;2 Version&nbsp;4.  It is not valid in
 * models defined using SBML Level&nbsp;2 versions prior to Version&nbsp;4.
 * If a Level&nbsp;2 Version&nbsp;1&ndash;3 model sets the attribute, the
 * consistency-checking method SBMLDocument::checkConsistency() will report
 * an error.</span>
 *
   */ public
 int setUseValuesFromTriggerTime(bool value) {
    int ret = libsbmlPINVOKE.Event_setUseValuesFromTriggerTime(swigCPtr, value);
    return ret;
  }

  
/**
   * Unsets the value of the 'id' attribute of this Event.
   *
   *
 *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 *
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The exception to this rule is that for InitialAssignment, EventAssignment, 
 * AssignmentRule, and RateRule objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The AlgebraicRule fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return @c false.
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(@if java String@endif), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 * 
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 *
 *
 * 
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
 *
 * @see getIdAttribute()
 * @see setIdAttribute(string sid)
 * @see isSetIdAttribute()
 * @see unsetIdAttribute()
 *
 *
   */ public new
 int unsetId() {
    int ret = libsbmlPINVOKE.Event_unsetId(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'name' attribute of this Event.
   *
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 * 
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
 *
 * @see getName()
 * @see setName(string sid)
 * @see isSetName()
 *
 *
   */ public new
 int unsetName() {
    int ret = libsbmlPINVOKE.Event_unsetName(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'useValuesFromTriggerTime' attribute of this Event.
   *
   *
 * 
 * The optional Delay on Event and the fact that multiple events may be
 * simultaneously executed means there are two times to consider when
 * computing the results of an event: the time at which the event is
 * <em>triggered</em>, and the time at which assignments are
 * <em>executed</em>.  It is also possible to distinguish between the
 * time at which the EventAssignment's expression is calculated, and the
 * time at which the assignment is made: the expression could be
 * evaluated at the same time the assignments are performed, i.e., when
 * the event is <em>executed</em>, but it could also be defined to be
 * evaluated at the time the event is <em>triggered</em>.
 * 
 * In SBML Level&nbsp;2 versions prior to Version&nbsp;4, the semantics
 * of Event time delays were defined such that the expressions in the
 * event's assignments were always evaluated at the time the event was
 * <em>triggered</em>.  This definition made it difficult to define an
 * event whose assignment formulas were meant to be evaluated at the time
 * the event was <em>executed</em> (i.e., after the time period defined
 * by the value of the Delay element, or after any other simultaneous
 * event may have been <em>executed</em> and changed the model state).
 * In SBML Level&nbsp;2
 * Version&nbsp;4, the attribute 'useValuesFromTriggerTime' on Event
 * allows a model to indicate the time at which the event's assignments
 * are intended to be evaluated.  In SBML Level&nbsp;2, the attribute has
 * a default value of @c true, which corresponds to the interpretation of
 * event assignments prior to Version&nbsp;4: the values of the
 * assignment formulas are computed at the moment the event is triggered,
 * not after the delay.  If 'useValuesFromTriggerTime'=@c false, it means
 * that the formulas in the event's assignments are to be computed after
 * the delay, at the time the event is executed.  In SBML Level&nbsp;3,
 * the attribute is mandatory, not optional, and all events must specify
 * a value for it.
 *
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @warning <span class='warning'>The attribute 'useValuesFromTriggerTime'
 * was introduced in SBML Level&nbsp;2 Version&nbsp;4.  It is not valid in
 * models defined using SBML Level&nbsp;2 versions prior to Version&nbsp;4.
 * If a Level&nbsp;2 Version&nbsp;1&ndash;3 model sets the attribute, the
 * consistency-checking method SBMLDocument::checkConsistency() will report
 * an error.</span>
 *
   */ public
 int unsetUseValuesFromTriggerTime() {
    int ret = libsbmlPINVOKE.Event_unsetUseValuesFromTriggerTime(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the Delay of this Event.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public
 int unsetDelay() {
    int ret = libsbmlPINVOKE.Event_unsetDelay(swigCPtr);
    return ret;
  }

  
/**
   * (SBML Level&nbsp;3 only) Unsets the Priority of this Event.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * 
   * @note The element 'priority' is available in SBML Level&nbsp;3,
   * but is not present in lower Levels of SBML.
   */ public
 int unsetPriority() {
    int ret = libsbmlPINVOKE.Event_unsetPriority(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the Trigger of this Event.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * 
   * @note The element 'priority' is available in SBML Level&nbsp;3,
   * but is not present in lower Levels of SBML.
   */ public
 int unsetTrigger() {
    int ret = libsbmlPINVOKE.Event_unsetTrigger(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the 'timeUnits' attribute of this Event.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @warning <span class='warning'>Definitions of Event in SBML Level 2
 * Versions&nbsp;1 and&nbsp;2 included the additional attribute called
 * 'timeUnits', but it was removed in SBML Level&nbsp;2 Version&nbsp;3.
 * LibSBML supports this attribute for compatibility with previous versions
 * of SBML Level&nbsp;2, but its use is discouraged since models in
 * Level&nbsp;2 Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a
 * Version&nbsp;3 or&nbsp;4 model sets the attribute, the
 * consistency-checking method SBMLDocument::checkConsistency() will report
 * an error.</span>
 *
   */ public
 int unsetTimeUnits() {
    int ret = libsbmlPINVOKE.Event_unsetTimeUnits(swigCPtr);
    return ret;
  }

  
/**
   * Appends a copy of the given EventAssignment to this Event.
   *
   * @param ea the EventAssignment object to add.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 * 
   *
   * @see createEventAssignment()
   */ public
 int addEventAssignment(EventAssignment ea) {
    int ret = libsbmlPINVOKE.Event_addEventAssignment(swigCPtr, EventAssignment.getCPtr(ea));
    return ret;
  }

  
/**
   * Creates a new, empty EventAssignment, adds it to this Event's list of
   * event assignments and returns the EventAssignment.
   *
   * @return the newly created EventAssignment object instance.
   *
   * @see addEventAssignment(EventAssignment ea)
   */ public
 EventAssignment createEventAssignment() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Event_createEventAssignment(swigCPtr);
    EventAssignment ret = (cPtr == global::System.IntPtr.Zero) ? null : new EventAssignment(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new, empty Trigger, adds it to this Event and 
   * returns the Trigger.
   *
   * @return the newly created Trigger object instance.
   */ public
 Trigger createTrigger() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Event_createTrigger(swigCPtr);
    Trigger ret = (cPtr == global::System.IntPtr.Zero) ? null : new Trigger(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new, empty Delay, adds it to this Event and 
   * returns the Delay.
   *
   * @return the newly created Delay object instance.
   */ public
 Delay createDelay() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Event_createDelay(swigCPtr);
    Delay ret = (cPtr == global::System.IntPtr.Zero) ? null : new Delay(cPtr, false);
    return ret;
  }

  
/**
   * (SBML Level&nbsp;3 only) Creates a new, empty Priority, adds it to this
   * Event and returns the Priority.
   *
   * @return the newly created Priority object instance, or @c null if the SBML
   * level and version used for this Event does not define Priority children.
   * 
   * @note The element 'priority' is available in SBML Level&nbsp;3,
   * but is not present in lower Levels of SBML.
   */ public
 Priority createPriority() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Event_createPriority(swigCPtr);
    Priority ret = (cPtr == global::System.IntPtr.Zero) ? null : new Priority(cPtr, false);
    return ret;
  }

  
/**
   * Returns the list of event assignments for this Event.
   * 
   * @return the list of EventAssignments for this Event.
   */ public
 ListOfEventAssignments getListOfEventAssignments() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Event_getListOfEventAssignments__SWIG_0(swigCPtr);
    ListOfEventAssignments ret = (cPtr == global::System.IntPtr.Zero) ? null : new ListOfEventAssignments(cPtr, false);
    return ret;
  }

  
/**
   * Return a specific EventAssignment object of this Event.
   *
   * @param n an integer, the index of the EventAssignment object to return.
   * 
   * @return the <code>n</code>th EventAssignment of this Event.
   */ public
 EventAssignment getEventAssignment(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Event_getEventAssignment__SWIG_0(swigCPtr, n);
    EventAssignment ret = (cPtr == global::System.IntPtr.Zero) ? null : new EventAssignment(cPtr, false);
    return ret;
  }

  
/**
   * Return the event assignment indicated by the given @p variable.
   *
   * @param variable a string, the identifier of the variable whose
   * EventAssignment is being sought.
   *
   * @return the EventAssignment for the given @p variable, or @c null if
   * no such EventAssignment exists.
   */ public
 EventAssignment getEventAssignment(string variable) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Event_getEventAssignment__SWIG_2(swigCPtr, variable);
    EventAssignment ret = (cPtr == global::System.IntPtr.Zero) ? null : new EventAssignment(cPtr, false);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Returns the number of EventAssignment objects attached to this
   * Event.
   * 
   * @return the number of EventAssignments in this Event.
   */ public
 long getNumEventAssignments() { return (long)libsbmlPINVOKE.Event_getNumEventAssignments(swigCPtr); }

  
/**
   * Removes the nth EventAssignment object from this Event object and
   * returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param n the index of the EventAssignment object to remove.
   *
   * @return the EventAssignment object removed.  As mentioned above, 
   * the caller owns the returned item. @c null is returned if the given index 
   * is out of range.
   *
   */ public
 EventAssignment removeEventAssignment(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Event_removeEventAssignment__SWIG_0(swigCPtr, n);
    EventAssignment ret = (cPtr == global::System.IntPtr.Zero) ? null : new EventAssignment(cPtr, true);
    return ret;
  }

  
/**
   * Removes the EventAssignment object with the given 'variable' attribute 
   * from this Event object and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   * If none of the EventAssignment objects in this Event object have the 
   * 'variable' attribute @p variable, then @c null is returned.
   *
   * @param variable the 'variable' attribute of the EventAssignment object 
   * to remove.
   *
   * @return the EventAssignment object removed.  As mentioned above, the 
   * caller owns the returned object. @c null is returned if no EventAssignment
   * object with the 'variable' attribute exists in this Event object.
   */ public
 EventAssignment removeEventAssignment(string variable) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Event_removeEventAssignment__SWIG_1(swigCPtr, variable);
    EventAssignment ret = (cPtr == global::System.IntPtr.Zero) ? null : new EventAssignment(cPtr, true);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public override void connectToChild() {
    libsbmlPINVOKE.Event_connectToChild(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public new
 void enablePackageInternal(string pkgURI, string pkgPrefix, bool flag) {
    libsbmlPINVOKE.Event_enablePackageInternal(swigCPtr, pkgURI, pkgPrefix, flag);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/** */ /* libsbml-internal */ public new
 void updateSBMLNamespace(string package, long level, long version) {
    libsbmlPINVOKE.Event_updateSBMLNamespace(swigCPtr, package, level, version);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Returns the libSBML type code of this object instance.
   *
   *
 * 
 * LibSBML attaches an identifying code to every kind of SBML object.  These
 * are integer constants known as <em>SBML type codes</em>.  The names of all
 * the codes begin with the characters <code>SBML_</code>.
 * @if clike The set of possible type codes for core elements is defined in
 * the enumeration #SBMLTypeCode_t, and in addition, libSBML plug-ins for
 * SBML Level&nbsp;3 packages define their own extra enumerations of type
 * codes (e.g., #SBMLLayoutTypeCode_t for the Level&nbsp;3 Layout
 * package).@endif@if java In the Java language interface for libSBML, the
 * type codes are defined as static integer constants in the interface class
 * {@link libsbmlConstants}.  @endif@if python In the Python language
 * interface for libSBML, the type codes are defined as static integer
 * constants in the interface class @link libsbml@endlink.@endif@if csharp In
 * the C# language interface for libSBML, the type codes are defined as
 * static integer constants in the interface class
 * @link libsbmlcs.libsbml@endlink.@endif  Note that different Level&nbsp;3
 * package plug-ins may use overlapping type codes; to identify the package
 * to which a given object belongs, call the 
 * <code>@if conly SBase_getPackageName()
 * @else SBase::getPackageName()
 * @endif</code>
 * method on the object.
 *
 *
   *
   * @return the SBML type code for this object:
   * @link libsbml#SBML_EVENT SBML_EVENT@endlink (default).
   *
   *
 * @warning <span class='warning'>The specific integer values of the possible
 * type codes may be reused by different libSBML plug-ins for SBML Level&nbsp;3.
 * packages,  To fully identify the correct code, <strong>it is necessary to
 * invoke both getTypeCode() and getPackageName()</strong>.</span>
 *
 *
   *
   * @see getElementName()
   * @see getPackageName()
   */ public new
 int getTypeCode() {
    int ret = libsbmlPINVOKE.Event_getTypeCode(swigCPtr);
    return ret;
  }

  
/**
   * Returns the XML element name of this object, which for Event, is
   * always @c 'event'.
   * 
   * @return the name of this element, i.e., @c 'event'.
   */ public new
 string getElementName() {
    string ret = libsbmlPINVOKE.Event_getElementName(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if all the required attributes for this
   * Event object have been set.
   *
   * The required attributes for an Event object are:
   * @li 'useValuesfromTriggerTime' (required in SBML Level&nbsp;3)
   *
   * @return @c true if the required attributes have been set, @c false
   * otherwise.
   */ public new
 bool hasRequiredAttributes() {
    bool ret = libsbmlPINVOKE.Event_hasRequiredAttributes(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if all the required elements for this Event
   * object have been set.
   *
   * @note The required elements for an Event object are:
   * @li 'trigger' (required in SBML Level&nbsp;2 and Level&nbsp;3 Version&nbsp;1;
   *     optional in SBML Level&nbsp;3 Version&nbsp;2+
   * @li 'listOfEventAssignments' (required in SBML Level&nbsp;2; optional in Level&nbsp;3)
   */ public new
 bool hasRequiredElements() {
    bool ret = libsbmlPINVOKE.Event_hasRequiredElements(swigCPtr);
    return ret;
  }

}

}
