/* -*- pftp-c -*- */
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#if HAVE_STDLIB_H
# include <stdlib.h>
#endif
#if HAVE_INTTYPES_H
# include <inttypes.h>
#endif
#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#if HAVE_STDIO_H
# include <stdio.h>
#endif
#if HAVE_STRING_H
# include <string.h>
#endif

#include "pftp.h"
#include "pftp_speed.h"

#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

speed_data_t pftp_init_speed(uint64_t total, uint64_t start,
			     size_t lastgoodbuffersize)
{
    speed_data_t ret;

    ret = malloc(sizeof(speed_data_s));
    memset(ret, 0, sizeof(speed_data_s));
    
    ret->total = total;
    ret->done = start;
    ret->unknown = (ret->total == 0);
    // ret->lastspeed = 0.0;
    // ret->lastchange = 0;
    ret->speed = 0.0;
    ret->percent = 0.0f;
    ret->buffersize = lastgoodbuffersize;
    ret->lastdata = 0;
    gettimeofday(&ret->lasttime, NULL);
    
    return ret;
}

void pftp_free_speed(speed_data_t *speed, size_t *lastgoodbuffersize)
{
    if (speed && (*speed)) {
	(*lastgoodbuffersize) = (*speed)->buffersize;
	free((*speed));
	(*speed) = NULL;
    }
}

void pftp_update_speed(speed_data_t speed, size_t data)
{
    struct timeval now;
    long diffsec;
    
    gettimeofday(&now, NULL);
    diffsec = now.tv_sec - speed->lasttime.tv_sec;
    
    speed->done += data;
    speed->lastdata += data;
    
    if (diffsec > 0) {
	speed->speed = (double)speed->lastdata / (double)diffsec;    
	
	/*  if (speed->speed < speed->lastspeed) {
	    printf("speed < lastspeed (%d)\n", speed->lastchange);
	    speed->lastchange = !speed->lastchange;
	    }
	    
	    if (!speed->lastchange) {
	    speed->buffersize *= 2;
	    } else {
	    if (speed->buffersize > 256)
	    speed->buffersize /= 2;
	    }
	    
	    printf("%lu\n", speed->buffersize);
	    
	    speed->lastspeed = speed->speed; */
	
	speed->lasttime.tv_sec = now.tv_sec;
	speed->lasttime.tv_usec = 0;
	
	speed->lastdata = 0;
    }
    
    if (speed->total > 0) {
	speed->percent = ((float)speed->done * 100.0f) / (float)speed->total;
    } else {
	speed->percent = 0.0f;
    }
}

