/* -*- pftp-c -*- */
#ifndef PFTP_SSH_CHANNEL_H
#define PFTP_SSH_CHANNEL_H

typedef struct pftp_ssh_channel_s *pftp_ssh_channel_t;
typedef struct pftp_ssh_channel_master_s *pftp_ssh_channel_master_t;

pftp_ssh_channel_master_t pftp_ssh_init_channel_master(pftp_ssh_t ssh,
						       pftp_server_t ftp);

void pftp_ssh_free_channel_master(pftp_ssh_channel_master_t master);

int pftp_ssh_channel_master_touch(pftp_ssh_channel_master_t master,
				  unsigned long timeout);

pftp_ssh_channel_t pftp_ssh_open_channel_session(
    pftp_ssh_channel_master_t master, size_t max_size);

pftp_ssh_channel_t pftp_ssh_open_channel_x11(
    pftp_ssh_channel_master_t master, size_t max_size,
    const char *orig_addr, uint16_t orig_port);

pftp_ssh_channel_t pftp_ssh_open_channel_tcpip(
    pftp_ssh_channel_master_t master, size_t max_size,
    int forward,
    const char *dst_addr, uint16_t dst_port,
    const char *src_addr, uint16_t src_port);

int pftp_ssh_channel_request_subsystem(pftp_ssh_channel_t channel,
				       int want_reply, const char *subsystem);

void pftp_ssh_channel_close(pftp_ssh_channel_t channel);

ssize_t pftp_ssh_channel_write(pftp_ssh_channel_t channel, const void *data,
			       size_t size, speed_data_t speed);
ssize_t pftp_ssh_channel_read(pftp_ssh_channel_t channel, void *data, 
			      size_t size, speed_data_t speed);
size_t pftp_ssh_channel_read_avail(pftp_ssh_channel_t channel);

#endif /* PFTP_SSH_CHANNEL_H */
